% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-state.R
\name{qgis_using_json_input}
\alias{qgis_using_json_input}
\alias{qgis_using_json_output}
\title{Report if JSON objects are used for input to and output from 'qgis_process'}
\usage{
qgis_using_json_input()

qgis_using_json_output(query = FALSE, quiet = TRUE)
}
\arguments{
\item{query}{Logical.
Should the outcome of \code{qgis_using_json_output()} ignore the cached value?
The argument has effect on condition that no user setting 'use_json_output'
is in place (see Details).
\itemize{
\item If set as \code{TRUE}, the function simply returns \code{TRUE} and the cached value
for the current session is set as \code{TRUE}.
\item If set as \code{FALSE} (default), the function returns the cached value on
condition that it does not conflict with a 'use_json_\strong{in}put' user setting.
}}

\item{quiet}{Use \code{FALSE} to display more information,
possibly useful for debugging.}
}
\value{
A logical of length 1.
}
\description{
Returns a logical that reveals whether the JSON input and output methods are
used, respectively.
}
\details{
Since QGIS 3.24 the JSON input method of 'qgis_process' is used by default
when calling the command.
It allows to use certain algorithms that
require a more complex input argument, e.g. a list of lists (see
\code{\link[=qgis_list_input]{qgis_list_input()}}).

Likewise, JSON output is the default output format requested from
'qgis_process'.
Using the JSON input method of 'qgis_process' automatically implies
using the JSON output method; when \emph{not} using the JSON input method it is
possible (but not the default) to also not use the JSON output method.

The defaults can be overruled with the options
\code{qgisprocess.use_json_input} or \code{qgisprocess.use_json_output}, and with the
environment variables \code{R_QGISPROCESS_USE_JSON_INPUT} or
\code{R_QGISPROCESS_USE_JSON_OUTPUT}.

The returned JSON output method is always
cached during the current session by \code{qgis_using_json_output()}.
Given that \code{qgis_using_json_output()} is called by various functions
in the package, having a user setting 'use_json_output' in place (see above)
will have effect during subsequent usage of the package.
To cache the value between sessions, \code{\link[=qgis_configure]{qgis_configure()}} needs to be called
to update the value stored in the persistent package cache file.

The JSON input method is not cached but simply determined on the fly, based
on QGIS version, the JSON output method and the user setting if present.

There is good reason for having 'use_json_output' in the persistent package
cache: the values of \code{\link[=qgis_algorithms]{qgis_algorithms()}} and \code{\link[=qgis_plugins]{qgis_plugins()}} are different
with or without the JSON output method, and are also stored in the cache.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_using_json_input()
qgis_using_json_output()
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about programming or debugging utilities: 
\code{\link{qgis_result_status}()},
\code{\link{qgis_run}()},
\code{\link{qgis_tmp_file}()},
\code{\link{qgis_unconfigure}()}

Other topics about reporting the QGIS state: 
\code{\link{has_qgis}()},
\code{\link{qgis_algorithms}()},
\code{\link{qgis_path}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about programming or debugging utilities}
\concept{topics about reporting the QGIS state}
