% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_bounds.R
\name{modelbound}
\alias{modelbound}
\title{Estimating qgcomp regression line confidence bounds}
\usage{
modelbound(x, emmval = 0, alpha = 0.05, pwonly = FALSE, ...)
}
\arguments{
\item{x}{"qgcompemmfit" object from \code{qgcomp.emm.boot},}

\item{emmval}{fixed value for effect measure modifier at which pointwise comparisons are calculated}

\item{alpha}{alpha level for confidence intervals}

\item{pwonly}{logical: return only pointwise estimates (suppress simultaneous estimates)}

\item{...}{not used}
}
\value{
A data frame containing
\describe{
\item{linpred: }{The linear predictor from the marginal structural model}
\item{r/o/m: }{The canonical measure (risk/odds/mean) for the marginal structural model link}
\item{se....: }{the stndard error of linpred}
\item{ul..../ll....: }{Confidence bounds for the effect measure, and bounds centered at the canonical measure (for plotting purposes)}
}
The confidence bounds are either  "pointwise" (pw) and "simultaneous" (simul) confidence
intervals at each each quantized value of all exposures.
}
\description{
Calculates: expected outcome (on the link scale), and upper and lower
confidence intervals (both pointwise and simultaneous)
}
\details{
This method leverages the bootstrap distribution of qgcomp model coefficients
to estimate pointwise regression line confidence bounds. These are defined as the bounds
that, for each value of the independent variable X (here, X is the joint exposure quantiles)
the 95\% bounds (for example) for the model estimate of the regression line E(Y|X) are expected to include the
true value of E(Y|X) in 95\% of studies. The "simultaneous" bounds are also calculated, and the 95\%
simultaneous bounds contain the true value of E(Y|X) for all values of X in 95\% of studies. The
latter are more conservative and account for the multiple testing implied by the former. Pointwise
bounds are calculated via the standard error for the estimates of E(Y|X), while the simultaneous
bounds are estimated using the bootstrap method of Cheng (reference below). All bounds are large
sample bounds that assume normality and thus will be underconservative in small samples. These
bounds may also inclue illogical values (e.g. values less than 0 for a dichotomous outcome) and
should be interpreted cautiously in small samples.

Reference:

Cheng, Russell CH. "Bootstrapping simultaneous confidence bands."
Proceedings of the Winter Simulation Conference, 2005.. IEEE, 2005.
}
\examples{
set.seed(12)
\dontrun{
}
}
\seealso{
\code{\link[qgcompint]{qgcomp.emm.boot}}
}
