% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_multinomial.R
\name{qgcomp.multinomial.noboot}
\alias{qgcomp.multinomial.noboot}
\title{Quantile g-computation for multinomial outcomes}
\usage{
qgcomp.multinomial.noboot(
  f,
  data,
  expnms = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  weights,
  alpha = 0.05,
  bayes = FALSE,
  ...
)
}
\arguments{
\item{f}{R style formula}

\item{data}{data frame}

\item{expnms}{character vector of exposures of interest}

\item{q}{NULL or number of quantiles used to create quantile indicator variables
representing the exposure variables. If NULL, then gcomp proceeds with un-transformed
version of exposures in the input datasets (useful if data are already transformed,
or for performing standard g-computation)}

\item{breaks}{(optional) NULL, or a list of (equal length) numeric vectors that
characterize the minimum value of each category for which to
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}

\item{id}{(optional) NULL, or variable name indexing individual units of
observation (only needed if analyzing data with multiple observations per
id/cluster). Note that qgcomp.glm.noboot will not produce cluster-appropriate
standard errors (this parameter is essentially ignored in qgcomp.glm.noboot).
qgcomp.glm.boot can be used for this, which will use bootstrap
sampling of clusters/individuals to estimate cluster-appropriate standard
errors via bootstrapping.}

\item{weights}{"case weights" - passed to the "weight" argument of
\code{\link[nnet]{multinom}}}

\item{alpha}{alpha level for confidence limit calculation}

\item{bayes}{Logical, Not yet implemented (gives and error if set to TRUE)}

\item{...}{arguments to nnet::multinom}
}
\value{
a qgcompmultfit object, which contains information about the effect
measure of interest (psi) and associated variance (var.psi), as well
as information on the model fit (fit) and information on the
weights/standardized coefficients in the positive and
negative directions (weights).
}
\description{
Quantile g-computation for multinomial outcomes
}
\examples{
data("metals") # from qgcomp package
# create categorical outcome from the existing continuous outcome (usually, one will already exist)
metals$ycat = factor(quantize(metals, "y",q=4)$data$y, levels=c("0", "1", "2", "3"), 
                     labels=c("cct", "ccg", "aat", "aag")) 
# restrict to smaller dataset for simplicity
smallmetals = metals[,c("ycat", "arsenic", "lead", "cadmium", "mage35")]

### 1: Define mixture and underlying model ####
mixture = c("arsenic", "lead", "cadmium")
f0 = ycat ~ arsenic + lead + cadmium # the multinomial model 
# (be sure that factor variables are properly coded ahead of time in the dataset)

rr = qgcomp.multinomial.noboot(
 f0, 
 expnms = mixture,
 q=4, 
 data = smallmetals, 
 )
 
 ### 5: Create summary qgcomp object for nice printing ####
 
 summary(rr, tests=c("H")) # include homogeneity test
 
 # 95\% confidence intervals
 confint(rr, level=0.95)
 rr$breaks # quantile cutpoints for exposures
 # homogeneity_test(rr)
 joint_test(rr)

}
\seealso{
\code{\link[qgcomp]{qgcomp.glm.noboot}}, \code{\link[nnet]{multinom}}

Other qgcomp_methods: 
\code{\link{qgcomp.cch.noboot}()},
\code{\link{qgcomp.cox.boot}()},
\code{\link{qgcomp.cox.noboot}()},
\code{\link{qgcomp.glm.boot}()},
\code{\link{qgcomp.glm.noboot}()},
\code{\link{qgcomp.hurdle.boot}()},
\code{\link{qgcomp.hurdle.noboot}()},
\code{\link{qgcomp.multinomial.boot}()},
\code{\link{qgcomp.partials}()},
\code{\link{qgcomp.zi.boot}()},
\code{\link{qgcomp.zi.noboot}()}
}
\concept{qgcomp_methods}
\concept{variance mixtures}
