% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{gof}
\alias{gof}
\title{Goodness-of-fit for modeled predator signatures}
\usage{
gof(prey_sigs, prey_loc, mean_sigs, diet_est, conv, obj_func, dist_meas = 1,
  gamma = 1, boot_gof = 500)
}
\arguments{
\item{prey_sigs}{A matrix of prey signatures in the optimization space used
for diet estimation. Intended to be the object \code{prey_sigs} returned by
the function \code{\link{est_diet}}.}

\item{prey_loc}{A matrix giving the first and last locations of the
signatures of each prey type within \code{prey_sigs}. Intended to be the
object \code{loc} returned by the function \code{\link{prep_sig}} if diets
were estimated using an unpartitioned prey library or
\code{\link{make_prey_part}} if diets were estimated using a partitioned
library.}

\item{mean_sigs}{A numeric matrix of mean prey-type signatures in the
optimization space used for diet estimation. Intended to be the object
\code{mean_sigs} returned by the function \code{\link{est_diet}}.}

\item{diet_est}{A numeric matrix of estimated diet compositions. Intended to
be the object \code{est_ind} returned by the function
\code{\link{est_diet}}.}

\item{conv}{A logical vector indicating whether the optimization function
successfully converged during diet estimation. Intended to be the object
\code{conv} returned by the function \code{\link{est_diet}}.}

\item{obj_func}{A numeric vector of the value of the minimized objective
function for each predator. Intended to be the object \code{obj_func}
returned by the function \code{\link{est_diet}}.}

\item{dist_meas}{An integer indicator of the distance measure used for diet
estimation. Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}

\item{boot_gof}{The number of bootstrap replications to use. Default value 500.}
}
\value{
A list containing the following elements: \describe{
  \item{gof_ss}{The number of diet estimates that converged for each
    predator, therefore producing a simulated value of the objective
    function.}
  \item{p_val}{The proportion of the simulated objective function values that
    exceeded the value produced during diet estimation.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
}
}
\description{
The function \code{gof} uses estimated diet compositions and bootstrap
resampling of the prey library to construct a statistic that may
conservatively indicate predator fatty acid signatures that were not
accurately modeled during diet estimation.
}
\section{Details}{

Diet estimation involves modeling an observed predator fatty acid signature
as a mixture of prey signatures. However, methods to assess how well predator
signatures are modeled have received little attention in the literature
(but see Bromaghin et al. 2015).

One byproduct of diet estimation is the value of the distance measure that is
minimized during diet estimation (\code{\link{est_diet}}), called the
objective function. If a predator signature is accurately modeled, the
value of the objective function will be relatively small. Conversely, the
more poorly the signature is approximated, the larger the objective function
will tend to be. However, what value of the objective function to use as a
warning flag for a potentially poor fit is not clear.

The function \code{gof} represents one attempt to answer this question. The
algorithm is based on the following logic. First, we assume that a predator
consumes the mixture of prey specified by its estimated diet composition.
Given that assumption, the expected value of the objective function is, in
a sense, fixed (Bromaghin 2015). Large values of the objective function are
then most likely to occur when variation in a predator signature, which
results from the selection of individual prey within prey types, is
maximized. Within the framework of simulating predator signatures, variation
in the signatures is maximized when the bootstrap sample sizes of the prey
signatures used to construct a predator signature are minimized
(Bromaghin et al. 2016).

Implementing the above logic, \code{gof} randomly samples a single prey
signature from each prey type and weights the resulting signatures with a
predator's estimated diet composition to construct a modeled signature. The
modeled signature is then used to estimate diet. If the optimization function
converges, the value of the objective function obtained with the modeled
signature is compared to the value of the objective function obtained while
estimating diet with the observed signature (argument \code{obj_func}. This
is repeated \code{boot_gof} times and the proportion of the simulated
objective function values that exceed the observed objective function value
is computed. \code{gof} therefore constructs a statistic similar to a
p-value, with small values being suggestive of a predator signature that
was not closely approximated during diet estimation.

NOTE: the method implemented in \code{gof} is at this point only an idea
whose performance has not been explored. It has been included in
\code{qfasar} to support future research on this topic.
}

\section{References}{

Bromaghin, J.F. 2015. Simulating realistic predator signatures in
  quantitative fatty acid signature analysis. Ecological Informatics
  30:68-71.

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty acid
 signature proportions sum to 1 for diet estimation? Ecological Research
 31:597-606.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.
}
\examples{
gof(prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                         0.05, 0.09, 0.30, 0.56,
                         0.03, 0.10, 0.30, 0.57,
                         0.08, 0.07, 0.30, 0.55,
                         0.09, 0.05, 0.33, 0.53,
                         0.09, 0.06, 0.34, 0.51,
                         0.09, 0.07, 0.34, 0.50,
                         0.08, 0.11, 0.35, 0.46,
                         0.06, 0.14, 0.36, 0.44), ncol = 9),
    prey_loc = matrix(c(1, 4, 7, 3, 6, 9), ncol=2),
    mean_sigs = matrix(c(0.047, 0.093, 0.303, 0.557,
                         0.087, 0.050, 0.323, 0.530,
                         0.077, 0.106, 0.350, 0.467), ncol = 3),
    diet_est = matrix(c(0.025, 0.311, 0.273, 0.391,
                        0.116, 0.298, 0.327, 0.259)),
    conv = c(TRUE, TRUE),
    obj_func = c(1.13, 2.24),
    dist_meas = 1,
    gamma = NA,
    boot_gof = 250)

gof(prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                         0.05, 0.09, 0.30, 0.56,
                         0.03, 0.10, 0.30, 0.57,
                         0.08, 0.07, 0.30, 0.55,
                         0.09, 0.05, 0.33, 0.53,
                         0.09, 0.06, 0.34, 0.51,
                         0.09, 0.07, 0.34, 0.50,
                         0.08, 0.11, 0.35, 0.46,
                         0.06, 0.14, 0.36, 0.44), ncol = 9),
    prey_loc = matrix(c(1, 4, 7, 3, 6, 9), ncol=2),
    mean_sigs = matrix(c(0.047, 0.093, 0.303, 0.557,
                         0.087, 0.050, 0.323, 0.530,
                         0.077, 0.106, 0.350, 0.467), ncol = 3),
    diet_est = matrix(c(0.025, 0.311, 0.273, 0.391,
                        0.116, 0.298, 0.327, 0.259)),
    conv = c(TRUE, TRUE),
    obj_func = c(1.13, 2.24))

}

