% Generated by roxygen2 (4.0.2): do not edit by hand
\name{loc_split}
\alias{loc_split}
\alias{loc_split.character}
\alias{loc_split.data.frame}
\alias{loc_split.default}
\alias{loc_split.factor}
\alias{loc_split.list}
\alias{loc_split.matrix}
\alias{loc_split.numeric}
\title{Split Data Forms at Specified Locations}
\usage{
loc_split(x, locs, names = NULL, ...)

\method{loc_split}{list}(x, locs, names = NULL, ...)

\method{loc_split}{data.frame}(x, locs, names = NULL, ...)

\method{loc_split}{matrix}(x, locs, names = NULL, ...)

\method{loc_split}{numeric}(x, locs, names = NULL, ...)

\method{loc_split}{factor}(x, locs, names = NULL, ...)

\method{loc_split}{character}(x, locs, names = NULL, ...)

\method{loc_split}{default}(x, locs, names = NULL, ...)
}
\arguments{
\item{x}{A data form (\code{list}, \code{vector}, \code{data.frame},
\code{matrix}).}

\item{locs}{A vector of integer locations to split at.  If \code{locs}
contains the index 1, it will be silently dropped.}

\item{names}{Optional vector of names to give to the list elements.}

\item{\ldots}{Ignored.}
}
\value{
Returns of list of data forms broken at the \code{locs}.
}
\description{
Split data forms at specified integer locations.
}
\note{
Two dimensional object will retain dimension (i.e., \code{drop = FALSE}
is used).
}
\examples{
## character
loc_split(LETTERS, c(4, 10, 16))
loc_split(LETTERS, c(4, 10, 16), c("dog", "cat", "chicken", "rabbit"))

## numeric
loc_split(1:100, c(33, 66))

## factor
(p_chng <- head(1 + cumsum(rle(as.character(CO2[["Plant"]]))[[1]]), -1))
loc_split(CO2[["Plant"]], p_chng)

## list
loc_split(as.list(LETTERS), c(4, 10, 16))

## data.frame
(vs_change <- head(1 + cumsum(rle(as.character(mtcars[["vs"]]))[[1]]), -1))
loc_split(mtcars, vs_change)

## matrix
(mat <- matrix(1:50, nrow=10))
loc_split(mat, c(3, 6, 10))
}
\seealso{
\code{\link[qdapTools]{split_vector}},
\url{https://github.com/trinker/loc_split_example} for real life use.
}

