% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_city_state_zip.R
\name{rm_city_state_zip}
\alias{rm_city_state_zip}
\title{Remove/Replace/Extract City, State, & Zip}
\usage{
rm_city_state_zip(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_city_state_zip", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_city_state_zip} uses the
\code{rm_city_state_zip} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the city, state, & zip are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with city, state, & zip removed.
}
\description{
Remove/replace/extract city (single lower case word or multiple consecutive
capitalized words before a comma and state) + state (2 consecutive capital
letters) + zip code (5 digits or 5 + 4 digits) from a string.
}
\examples{
x <- paste0("I went to Washington Heights, NY 54321 for food! ",
   "It's in West ven,PA 12345, near Bolly Bolly Bolly, CA12345-1234!",
   "hello world")
rm_city_state_zip(x)
rm_city_state_zip(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{rm_number}};
  \code{\link{as_time}}, \code{\link{as_time2}},
  \code{\link{rm_time}}, \code{\link{rm_transcript_time}};
  \code{\link{rm_abbreviation}}; \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{rm_caps_phrase}}; \code{\link{rm_caps}};
  \code{\link{rm_citation_tex}}; \code{\link{rm_citation}};
  \code{\link{rm_city_state}}; \code{\link{rm_date}};
  \code{\link{rm_default}}; \code{\link{rm_dollar}};
  \code{\link{rm_email}}; \code{\link{rm_emoticon}};
  \code{\link{rm_endmark}}; \code{\link{rm_hash}};
  \code{\link{rm_nchar_words}}; \code{\link{rm_non_ascii}};
  \code{\link{rm_non_words}}; \code{\link{rm_percent}};
  \code{\link{rm_phone}}; \code{\link{rm_postal_code}};
  \code{\link{rm_repeated_characters}};
  \code{\link{rm_repeated_phrases}};
  \code{\link{rm_repeated_words}}; \code{\link{rm_tag}};
  \code{\link{rm_title_name}};
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{rm_white}}, \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{rm_zip}}
}
\keyword{date}

