% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_endmark}
\alias{rm_endmark}
\title{Remove/Replace/Extract Endmarks}
\usage{
rm_endmark(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_endmark", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_endmark} uses the
\code{rm_dollar} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the endmark strings are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with endmarks removed.
}
\description{
Remove/replace/extract endmarks from a string.
}
\details{
The default regular expression used by \code{rm_endmark} finds
endmark punctuation used in the \pkg{qdap} package; this includes ! . ? * AND
|.  This behavior can be altered (to ; AND : or to use just ! . AND ?) by
using a secondary regular expression from the
\code{\link[qdapRegex]{regex_usa}} data (or other dictionary) via
(\code{pattern = "@rm_endmark2"} or \code{pattern = "@rm_endmark3"}). See
\bold{Examples} for example usage.
}
\examples{
x <- c("I like the dog.", "I want it *|", "I;",
    "Who is| that?", "Hello world", "You...")

rm_endmark(x)
rm_endmark(x, extract=TRUE)

rm_endmark(x, pattern="@rm_endmark2")
rm_endmark(x, extract=TRUE, pattern="@rm_endmark2")

rm_endmark(x, pattern="@rm_endmark3")
rm_endmark(x, extract=TRUE, pattern="@rm_endmark3")
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{percent}

