% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_2long.R
\name{cm_2long}
\alias{cm_2long}
\title{A Generic to Long Function}
\usage{
cm_2long(..., v.name = "variable", list.var = TRUE, debug = TRUE)
}
\arguments{
\item{v.name}{An optional name for the column created for the list.var 
argument.}

\item{list.var}{logical.  If \code{TRUE} creates a column for the data frame 
created by each time.list passed to \code{cm_t2l}.}

\item{debug}{logical. If \code{TRUE} debugging mode is on.
\code{\link[qdap]{cm_time2long}} will return possible errors in time span 
inputs.}

\item{\ldots}{list object(s) in the form generated by 
\code{\link[qdap]{cm_df.temp}}, \code{\link[qdap]{cm_range.temp}}, or
\code{\link[qdap]{cm_time.temp}}.}
}
\value{
Returns a long data.frame of the correct \strong{cm_XXX} classes.
}
\description{
A wrapper for \code{cm_df2long}, \code{cm_range2long}, and \code{cm_time2long} that automatically detects the objects being read and outputs the correct form and class.
}
\examples{
\dontrun{
## cm_range2long use: 
foo <- list(
    person_greg = qcv(terms='7:11, 20:24, 30:33, 49:56'),
    person_researcher = qcv(terms='42:48'),
    person_sally = qcv(terms='25:29, 37:41'),
    person_sam = qcv(terms='1:6, 16:19, 34:36'),
    person_teacher = qcv(terms='12:15'),
    adult_0 = qcv(terms='1:11, 16:41, 49:56'),
    adult_1 = qcv(terms='12:15, 42:48'),
    AA = qcv(terms="1"),
    BB = qcv(terms="1:2, 3:10, 19"),
    CC = qcv(terms="1:9, 100:150")
)

foo2  <- list(
    person_greg = qcv(terms='7:11, 20:24, 30:33, 49:56'),
    person_researcher = qcv(terms='42:48'),
    person_sally = qcv(terms='25:29, 37:41'),
    person_sam = qcv(terms='1:6, 16:19, 34:36'),
    person_teacher = qcv(terms='12:15'),
    adult_0 = qcv(terms='1:11, 16:41, 49:56'),
    adult_1 = qcv(terms='12:15, 42:48'),
    AA = qcv(terms="40"),
    BB = qcv(terms="50:90"),
    CC = qcv(terms="60:90, 100:120, 150"),
    DD = qcv(terms="")
)

cm_2long(foo, foo2, v.name = "time")

## cm_time2long use: 
x <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 
        9.00, 1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)
cm_2long(x)

## cm_df2long use:
codes <- qcv(dc, sf, wes, pol, rejk, lk, azx, mmm)
x1 <- cm_df.temp(DATA, "state", codes)
#fill it randomly
x1[, 7:14] <- lapply(7:14,  function(i) sample(0:1, nrow(x1), TRUE))
out2 <- cm_2long(x1)
head(out2, 15)
plot(out2)
}
}
\seealso{
\code{\link[qdap]{cm_df2long}},
\code{\link[qdap]{cm_range2long}},
\code{\link[qdap]{cm_time2long}}
}
\keyword{long}
