% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/strip.R
\name{strip}
\alias{strip}
\alias{strip.character}
\alias{strip.default}
\alias{strip.factor}
\alias{strip.list}
\title{Strip Text}
\usage{
strip(x, char.keep = "~~", digit.remove = TRUE, apostrophe.remove = TRUE,
  lower.case = TRUE)

\method{strip}{character}(x, char.keep = "~~", digit.remove = TRUE,
  apostrophe.remove = TRUE, lower.case = TRUE)

\method{strip}{factor}(x, char.keep = "~~", digit.remove = TRUE,
  apostrophe.remove = TRUE, lower.case = TRUE)

\method{strip}{default}(x, char.keep = "~~", digit.remove = TRUE,
  apostrophe.remove = TRUE, lower.case = TRUE)

\method{strip}{list}(x, char.keep = "~~", digit.remove = TRUE,
  apostrophe.remove = TRUE, lower.case = TRUE)
}
\arguments{
\item{x}{The text variable.}

\item{char.keep}{A character vector of symbols (i.e., punctuation) that
\code{\link[qdap]{strip}} should keep.  The default is to strip every symbol
except apostrophes and a double tilde \code{"~~"}.  The double tilde
\code{"~~"} is included for a convenient means of keeping word groups
together in functions that split text apart based on spaces.  To remove
double tildes \code{"~~"} set \code{char.keep} to \code{NULL}.}

\item{digit.remove}{logical.  If \code{TRUE} strips digits from the text.}

\item{apostrophe.remove}{logical.  If \code{TRUE} removes apostrophes from
the output.}

\item{lower.case}{logical.  If \code{TRUE} forces all alpha characters to
lower case.}
}
\value{
Returns a vector of text that has been stripped of unwanted characters.
}
\description{
Strip text of unwanted characters.

\code{strip.character} - factor method for \code{strip}.

\code{strip.factor} - factor method for \code{strip}.

\code{strip.default} - factor method for \code{strip}.

\code{strip.list} - factor method for \code{strip}.
}
\examples{
\dontrun{
DATA$state #no strip applied
strip(DATA$state)
strip(DATA$state, apostrophe.remove=FALSE)
strip(DATA$state, char.keep = c("?", "."))
}
}
\seealso{
\code{\link[qdap]{rm_stopwords}}
}

