% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable2.R
\name{px_variable_label}
\alias{px_variable_label}
\alias{px_variable_label.px}
\title{Change VARIABLE-LABEL}
\usage{
px_variable_label(x, value, validate)

\method{px_variable_label}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string or data frame.
\itemize{
\item Use character to set VARIABLE-LABEL for all languages and STUB/HEADING
variables.
\item Use data frame with columns 'variable-code', 'language' and
'variable-label' to set VARIABLE-LABEL for specific variables.
\item If missing, the current VARIABLE-LABEL is returned.
\item If NULL, VARIABLE-LABEL is removed for all variables.
}}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object, a character string, or a data frame.
}
\description{
Inspect or change VARIABLE-LABEL.

The variable label is the name that is shown in the PX-file.
}
\examples{
# Set VARIABLE-LABEL for individual variables
library(tibble)
x1 <-
  px(population_gl) |>
  px_variable_label(tribble(~`variable-code`, ~`variable-label`,
                            'gender',         'Gender',
                            'age',            'Age'))
px_variable_label(x1)

# Set VARIABLE-LABEL for individual languages
x2 <-
  x1 \%>\%
  px_languages(c('en', 'kl')) |>
  px_variable_label(tribble(~`variable-code`, ~language, ~`variable-label`,
                            'gender',         'en',      'Gender',
                            'gender',         'kl',      'Suiaassuseq',
                            'age',            'en',      'Age',
                            'age',            'kl',      'Ukiut'))
px_variable_label(x2)

# Remove VARIABLE-LABEL
x3 <- px_variable_label(x2, NULL)
px_variable_label(x3)
}
