#' FDA Statin dataset with 46 adverse effects
#'
#' Drug-AE dataset (contingency table) obtained from the FAERS
#' databases for the quarters 2014Q3 - 2020Q4
#'
#' Drugs are stored across columns, and the 46 AEs are stored across the rows
#'
#' the dataset includes 6 statin drugs:
#'
#' Atorvastatin, Fluvastatin, Lovastatin, Pravastatin, Rosuvastatin, Simvastatin
#'
#' Corresponding to 46 important adverse effects (PTs) as specified by FDA.
#'
#' @source \url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
"statin46"


#' FDA Statin dataset with 1491 adverse effects
#'
#' Drug-AE dataset (contingency table) obtained from the FAERS
#' databases for the quarters 2014Q3 - 2020Q4
#'
#' Drugs are stored across columns, and the 1491 AEs are stored across the rows
#'
#' the dataset includes 6 statin drugs:
#'
#' Atorvastatin, Fluvastatin, Lovastatin, Pravastatin, Rosuvastatin, Simvastatin
#'
#' Corresponding to 1491 adverse effects (PTs) common between statins and GBCA
#'
#' @source \url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
"statin1491"


#' FDA Statin dataset with all observed 6039 adverse effects
#'
#'
#' Drug-AE dataset (contingency table) obtained from the FAERS
#' databases for the quarters 2014Q3 - 2020Q4
#'
#' Drugs are stored across columns, and the 6039 AEs are stored across the rows
#'
#' the dataset includes 6 statin drugs
#'
#' Atorvastatin, Fluvastatin, Lovastatin, Pravastatin, Rosuvastatin, Simvastatin
#'
#' Corresponding to all 6039 observed adverse effects (PTs) observed in statins
#'
#' @source \url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
"statin"


#' FDA lovastatin dataset
#'
#'
#' Lovastatin Drug-AE dataset (contingency table) obtained from the FAERS
#' databases for the quarters 2014Q3 - 2020Q4
#'
#' Drugs are stored across columns, and the 46 AEs are stored across the rows
#'
#'
#' Includes 1 column for lovastatin, and one combined column for all other drugs.
#'
#' @source \url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
"lovastatin"


#' FDA GBCA dataset with all observed 1707 adverse effects
#'
#'
#' Drug-AE dataset (contingency table) obtained from the FAERS
#' databases for the quarters 2014Q3 - 2020Q4
#'
#' Drugs are stored across columns, and the 1491 AEs are stored across the rows
#'
#' the dataset includes 6 GBCA drugs:
#'
#' gadobenate, gadobutrol, gadodiamide, gadofosveset, gadopentetate, gadoterate,
#' gadoteridol, gadoversetamide, gadoxetate
#'
#' Corresponding to all 1707 observed adverse effects (PTs) as curated in FAERS database.
#'
#' @source \url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
"gbca"
