% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_glance.R
\name{update_glance}
\alias{update_glance}
\title{Update a Pushover glance data}
\usage{
update_glance(title = NULL, text = NULL, subtext = NULL, count = NULL,
  percent = NULL, user = get_pushover_user(), app = get_pushover_app(),
  device = NULL)
}
\arguments{
\item{title}{(optional) a description of the data being shown, such as "Widgets Sold" (max. 100 characters)}

\item{text}{(optional) the main line of data, used on most screens (max. 100 characters)}

\item{subtext}{(optional) a second line of data (max. 100 characters)}

\item{count}{(optional) integer value shown on smaller screens; useful for simple counts}

\item{percent}{(optional) integer percent value (0..100) shown on some screens as a progress bar/circle}

\item{user}{user/group key (see \code{\link{set_pushover_user}})}

\item{app}{application token (see \code{\link{set_pushover_app}})}

\item{device}{(optional) name of the device(s) to send message to. Defaults
to all devices.}
}
\value{
an invisible list containing the following fields:
\itemize{
    \item \code{status}: request status (1 = success)
    \item \code{request}: unique request ID
    \item \code{raw}: the raw \code{\link[httr]{response}} object
    \item \code{errors}: a list of error messages (only for unsuccessful requests)
}
}
\description{
Glances allow you to push small pieces of data to a frequently-updated screen
such as a smartwatch or a lock screen. At least one of the \code{title},
\code{text}, \code{subtext}, \code{count}, or \code{percent} arguments must
be specified.
}
\note{
Glances are currently in beta, and features may change.
}
\examples{
\dontrun{
update_glance(count = 37)
}
}

