% Generated by roxygen2 (4.0.2): do not edit by hand
\name{check_receipt}
\alias{check_receipt}
\alias{is.acknowledged}
\title{Determine whether or not an emergency message has been acknowledged}
\usage{
check_receipt(receipt, ...)

is.acknowledged(receipt, info = TRUE, ...)
}
\arguments{
\item{receipt}{A message receipt (e.g., 'KAWXTswy4cekx6vZbHBKbCKk1c1fdf')}

\item{...}{An application token can be specified with \code{token}}

\item{info}{\code{is.acknowledged} will print out additional information
about who acknowledged the message, when, and if and when the callback URL}
}
\value{
A \code{\link{PushoverResponse}} object containing the response from
the server

\code{is.acknowledged} returns a boolean indicating whether the
message has been acknowledged (\code{TRUE}) or not (\code{FALSE})
}
\description{
\code{check_receipt} issues a query to Pushover to determine whether or not
an emergency-priority message has been acknowledged and when (if applicable).
If a callback URL was specified with the message, it will also report whether
or not that callback URL was POSTed to and when.

\code{is.acknowledged} checks to see whether or not the given emergency
message receipt has been acknowledged or not.
}
\details{
\code{is.acknowledged} returns whether a message was acknowledged
(\code{TRUE}) or not (\code{FALSE}) as well as some information about when
the message was received and by whom.
}
\note{
Message receipts can be acquired using \code{\link{receipt}} on the
\code{\link{PushoverResponse}} object storing the response to an emergency
message.

The token argument is necessary, however it does not need to be given
if the application token have been set with \code{\link{set_pushover_app}}.
}
\examples{
\dontrun{
response <- check_receipt(token='KzGDORePK8gMaC0QOYAMyEEuzJnyUi',
                          receipt='KAWXTswy4cekx6vZbHBKbCKk1c1fdf')

if(is.acknowledged(token='KzGDORePK8gMaC0QOYAMyEEuzJnyUi',
                   receipt='KAWXTswy4cekx6vZbHBKbCKk1c1fdf'))
{
    cat('Message has been read.\\n')
}
}
}

