% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req_ni_r.R
\name{req_ni_r}
\alias{req_ni_r}
\title{req_ni_r}
\usage{
req_ni_r(
  ri.o,
  ni.o,
  m1i.o,
  m2i.o,
  n1i.o,
  n2i.o,
  sd1i.o,
  sd2i.o,
  tobs.o,
  alpha,
  des.pprob,
  des.pow,
  lo = 4,
  hi = 1e+05
)
}
\arguments{
\item{ri.o}{A numeric value containing the raw correlation coefficient
of the original study}

\item{ni.o}{An integer containing the sample size for the raw correlation 
coefficient}

\item{m1i.o}{A numeric value containing the mean in group 1 of the original
study for two-independent means}

\item{m2i.o}{A numeric value containing the mean in group 2 of the original
study for two-independent means}

\item{n1i.o}{A numeric value containing the sample size in group 1 of
the original study for two-independent means}

\item{n2i.o}{A numeric value containing the sample size in group 2 of
the original study for two-independent means}

\item{sd1i.o}{A numeric value containing the standard deviation in group 1
of the original study for two-independent means}

\item{sd2i.o}{A numeric value containing the standard deviation in group 2
of the original study for two-independent means}

\item{tobs.o}{A numeric value containing the t-value of the original
study}

\item{alpha}{A numeric value specifying the alpha level as used in the original study}

\item{des.pprob}{A numeric value specifying the posterior probability that an user
desires to obtain for one of the four true effect sizes}

\item{des.pow}{A numeric value specifying the probability of observing a posterior
probability larger than des.pprob that an user desires to obtain for one of the
four true effect sizes}

\item{lo}{A numeric value specifying the lower bound of the search interval that is
used for the optimization procedure (default is 4)}

\item{hi}{A numeric value specifying the upper bound of the search interval that is
used for the optimization procedure (default is 100,000)}
}
\value{
The \code{req.ni.r} function returns a 4x2 matrix with in the first
column the required total sample size of the replication when information of the
original study is taken into account and in the second column the required sample
size if information of the original study is ignored.
}
\description{
Function for computing the required sample size for a replication based on the
Snapshot Bayesian Hybrid Meta-Analysis Method for two-independent
means and raw correlation coefficients.
}
\details{
The function computes the required sample size for the replication based
on the Snapshot Bayesian Hybrid Meta-Analysis Method for four true effect sizes
(no, small, medium, and large). The required sample size is computed by optimizing
\eqn{P(\pi_x \ge a)=b} with \eqn{\pi_x} being the posterior probability with x
referring to no (0), small (S), medium (M), and large (L) true effect size and \eqn{a}
the desired posterior probability, and \eqn{b} the desired probability of observing
a posterior probability larger than \eqn{a}. The required sample size for the
replication is computed with and without including information of the original
study. Computing the required sample size with the Snapshot Bayesian Hybrid
Meta-Analysis Method is akin to computing the required sample size with a power
analysis in null hypothesis significance testing. For more information see van
Aert and van Assen (2016).

The \code{req.ni.r} function assumes that a two-tailed hypothesis test was
conducted in the original study. In case one-tailed hypothesis tests was
conducted in the original study, the alpha level has to be multiplied by two.
For example, if a one-tailed hypothesis test was conducted with an alpha level
of .05, an alpha of 0.1 has to be submitted to \code{req.ni.r}.
}
\examples{
### Example as presented on page 491 in Maxwell, Lau, and Howard (2015)
req_ni_r(ri.o = 0.243, ni.o = 80, alpha = .05, des.pprob = 0.75, des.pow = 0.8)

}
\references{
van Aert, R.C.M. & van Assen, M.A.L.M. (2016). Bayesian evaluation
of effect size after replicating an original study. Manuscript submitted for
publication.
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
