% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.character}
\alias{style.apa.character}
\title{Formats a character vector}
\usage{
style.apa.character(x, as.identifier = FALSE, replace = TRUE)
}
\arguments{
\item{x}{a list. All list items have to be character vectors.}

\item{as.identifier}{a logical. If \code{TRUE} character vector is handled
as identifiers (this is mainly for special treatment in HTML output mode).}

\item{replace}{a logical, specifying whether identifiers are replaced with
more proper names (e.g. \code{R^2} will be written in proper output format
or \code{cor} is replaced with \code{r}).}
}
\value{
character vector.
}
\description{
This style functions takes character vectors in a list and returns it
unlisted. This is mainly for putting math mode and brackets around the
character vector using \code{\link{pprint}}, but may be used to replace
identifier names in character vectors as well.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
pprint(c("test 1", "test 2"), format="character")
}
\seealso{
Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

