% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bar_error}
\alias{bar_error}
\title{Bar charts with error bars.}
\usage{
bar_error(
  object = NULL,
  formula = NULL,
  data = NULL,
  fill = "indianred3",
  col = "black",
  alpha = 0.7,
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: \code{y ~ x} or \code{y ~ x|z} where \code{y} is a
numerical variable and both \code{x} and \code{z} are factors.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{fill}{Colour used to fill the bars.}

\item{col}{Colour used for the borders of the bars.}

\item{alpha}{Opacity of the colour fill (0 = invisible, 1 = opaque).}

\item{...}{Additional information passed to \code{\link{gf_summary}}.}
}
\description{
\code{bar_error} constructs bar charts in with error bars showing 95% bootstrapped
confidence intervals around mean values. High of bars represent mean values.
}
\examples{
require(dplyr)
require(sjlabelled)
data(birthwt, package = "MASS")
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    Race = factor(race > 1, labels = c("White", "Non-white"))
  ) \%>\%
  var_labels(
    bwt = 'Birth weight (g)',
    smoke = 'Smoking status'
 )

birthwt \%>\%
  bar_error(bwt ~ smoke, fill = 'plum3') \%>\%
  axis_labs()

birthwt \%>\%
  bar_error(bwt ~ smoke|Race, fill = 'plum3') \%>\%
  axis_labs()

birthwt \%>\%
  bar_error(bwt ~ smoke, fill = ~ Race) \%>\%
  axis_labs()

birthwt \%>\%
  bar_error(bwt ~ smoke, col = ~ Race, fill = 'white') \%>\%
  gf_refine(ggsci::scale_color_jama()) \%>\%
  axis_labs()
}
