% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Fentress}
\alias{Fentress}
\title{Migraine pain reduction.}
\format{A labelled data frame with 18 rows and 2 variables:
\describe{
\item{pain}{Reduction in weekly headache activity expressed as percentage of baseline data.}
\item{group}{Group, a factor with levels "Untreated", "Relaxation" (alone) and "Biofeedback" (relaxation
and biofeedback).}
}}
\source{
Fentress, DW, et al. (1986) Biofeedback and relaxation-response in the treatment of pediatric
migraine. Dev Med Child Neurol 28:1 39-46.

Altman, DA (1991) Practical statistics for medical research. Chapman & Hall/CRC.
}
\usage{
Fentress
}
\description{
Randomised control trial on children suffering from frequent and severe migraine. Control group represents
untreated children. The active treatments were either relaxation alone or relaxation with biofeedback.
}
\examples{
data(Fentress)

Fentress \%>\%
  strip_error(pain ~ group) \%>\%
  axis_labs()
}
\keyword{datasets}
