% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{runs_on_route}
\alias{runs_on_route}
\title{Runs on a given route}
\usage{
runs_on_route(
  route_id,
  route_type = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_id}{Integer. These can be listed and described with the \code{routes}
function.}

\item{route_type}{Optionally filter results by a route type. A route type can
be provided either as a non-negative integer code, or as a character:
"Tram", "Train", "Bus", "Vline" or "Night Bus". Character inputs are not
case-sensitive. Use the \code{route_types} function to extract a vector of all
route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item \code{run_id}
\item \code{route_id}
\item \code{route_type}
\item \code{direction_id}
\item \code{run_sequence}
\item \code{final_stop_id}
\item \code{destination_name}
\item \code{status}
\item \code{express_stop_count}
\item \code{vehicle_position}
\item \code{vehicle_descriptor}
}
}
\description{
Runs on a given route
}
\examples{
\dontrun{
runs_on_route(6)
runs_on_route(6, route_type = "Train")
runs_on_route(6, route_type = 0)
}

}
