% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_ptglmm.R
\name{simulate_ptglmm}
\alias{simulate_ptglmm}
\title{Simulate data from the Poisson-Tweedie generalized linear mixed model}
\usage{
simulate_ptglmm(
  n = 20,
  t = 5,
  seed = 1,
  beta = c(3, 0, 0, 0.4),
  D = 1.5,
  a = -1,
  sigma2 = 0.8^2,
  offset = F
)
}
\arguments{
\item{n}{number of subjects}

\item{t}{number of time points (0, 1, ..., t-1)}

\item{seed}{seed for random number generation}

\item{beta}{vector of regression coefficients, to be specified in
this order: intercept, group main effect, time main effect, group*time interaction}

\item{D}{dispersion parameter of the Poisson-Tweedie distribution (D > 1)}

\item{a}{power parameter of the Poisson-Tweedie distribution (a < 1)}

\item{sigma2}{Variance of the subject-specific random intercept}

\item{offset}{Logical value. If \code{TRUE}, a normally-distributed offset is added to the linear predictor.}
}
\value{
A list containing the following elements: a dataframe (\code{data})
containing the response y, the subject id, the group indicator and time;
a vector with the true random intercept values (\code{true.randint}).
}
\description{
Simulates a dataset comprising t repeated measurements for n subjects
from a Poisson-Tweedie GLMM. Subjects are assumed to belong to two
different groups. The linear predictor comprises an intercept,
main effects of group and of time, and the interaction between time and
group; a random intercept; and, optionally, a normally-distributed
offset term.
}
\examples{
# simulate a simple, small dataset
example1 = simulate_ptglmm(n = 5, t = 2)
example1$data
# the function allows to set several different parameters
example2 = simulate_ptglmm(n = 20, t = 5, seed = 1,
beta = c(2.2, 1.2, 0.3, -0.5), D = 1.8, a = 0.5,
sigma2 = 0.7, offset = TRUE)
# view the distribution of the response variable:
pmf(example2$data$y)
# visualize the data with a trajectory plot:
make.spaghetti(x = time, y = y, id = id,
group = group, data = example2$data)
}
\author{
Mirko Signorelli
}
