% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{parse.dssp}
\alias{parse.dssp}
\title{Parse a DSSP File to Return a Dataframe}
\usage{
parse.dssp(file, keepfiles = FALSE)
}
\arguments{
\item{file}{input dssp file.}

\item{keepfiles}{logical, if TRUE the dataframe will be saved in the working directory and we will keep the dssp file.}
}
\value{
Returns a dataframe providing data for 'acc', 'ss', 'phi' and 'psi' for each residues from the structure.
}
\description{
Parses a DSSP file to return a dataframe.
}
\details{
If the argument 'keepfiles' is not set to TRUE, the dssp file used to get the parsed dataframe will be removed.
}
\examples{
\dontrun{compute.dssp('3cwm'); parse.dssp('3cwm.dssp')}
}
\references{
Touw et al (2015) Nucl. Ac. Res. 43(Database issue): D364-D368 (PMID: 25352545).
}
\seealso{
download.dssp(), compute.dssp(), mkdssp() and acc.dssp()
}
\author{
Juan Carlos Aledo
}
