% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{dpx}
\alias{dpx}
\title{Atom Depth Analysis}
\usage{
dpx(pdb)
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file.}
}
\value{
A dataframe with the computed depths.
}
\description{
Computes the depth from the surface for each protein's atom.
}
\details{
This function computes the depth, defined as the distance in angstroms between the target atom and the closest atom on the protein surface.
}
\examples{
\dontrun{dpx('3cwm')}
}
\references{
Pintar et al. 2003. Bioinformatics 19:313-314 (PMID: 12538266)
}
\seealso{
compute.dssp(), atom.dpx(), res.dpx(), acc.dssp(), str.part()
}
\author{
Juan Carlos Aledo
}
