% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmScan.R
\name{ptm.scan}
\alias{ptm.scan}
\title{Scan a Protein in Search of PTM Sites}
\usage{
ptm.scan(up_id, renumerate = TRUE)
}
\arguments{
\item{up_id}{a character string corresponding to the UniProt ID.}

\item{renumerate}{logical, when TRUE the  sequence numeration of MetO sites is that given by Uniprot, which may not coincide with that from MetOSite.}
}
\value{
Returns a dataframe where each row corresponds to a residue, and the columns inform about the modifications.
}
\description{
Scans the indicated protein in search of PTM sites.
}
\details{
The numerations of the sequences given by UniProt and MetOSite may or may not match. Sometimes one of the sequences corresponds to the precursor protein and the other to the processed mature protein.
}
\examples{
\dontrun{ptm.scan('P01009', renumerate = TRUE)}
}
\references{
Hornbeck et al. Nucleic Acids Res. 2019 47:D433-D441, (PMID: 30445427).

Huang et al. Nucleic Acids Res. 2019 47:D298-D308, (PMID: 30418626).

Ullah et al. Sci. Rep. 2016 6:23534, (PMID: 27010073).

Durek et al. Nucleic Acids Res.2010 38:D828-D834, (PMID: 19880383).

Dinkel et al. Nucleic Acids Res. 2011 39:D261-D567 (PMID: 21062810).
}
\seealso{
meto.scan(), ac.scan(), me.scan(), ub.scan(), su.scan(), gl.scan(), sni.scan(), ni.scan(), p.scan(), reg.scan(), dis.scan()
}
\author{
Juan Carlos Aledo
}
