% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{hdfisher.go}
\alias{hdfisher.go}
\title{Hypothesis-Driven Fisher Test}
\usage{
hdfisher.go(target, background, query, analysis = 'enrichment')
}
\arguments{
\item{target}{either a vector containing the UniProt IDs of the target set or the path to the txt file containing the list of IDs.}

\item{background}{a dataframe with two columns (Uniprot ID and GO terms) and as many rows as different proteins there are in the background set.}

\item{query}{character string defining the query.}

\item{analysis}{a character string indicating whether the desired analysis is the enrichment ('enrichment') or depletion ('depletion').}
}
\value{
Returns a list that contains the contingency table and the p-Value.
}
\description{
Carries out an enrichment Fisher's test using a hypothesis driven approach.
}
\examples{
\dontrun{hdfisher.go(c('Q14667', 'Q5JSZ5'), bg.go(c('Q14667', 'Q5JSZ5', 'P13196')), 'ion')}
}
\references{
Rhee et al. (2008) Nature Reviews Genetics 9:509–515.
}
\seealso{
search.go(), term.go(), get.go(), bg.go(), go.enrich(), gorilla(), net.go()
}
\author{
Juan Carlos Aledo
}
