% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmScan.R
\name{gl.scan}
\alias{gl.scan}
\title{Scan a Protein in Search of OGlcNAc Sites}
\usage{
gl.scan(up_id, db = 'all')
}
\arguments{
\item{up_id}{a character string corresponding to the UniProt ID.}

\item{db}{the database where to search. It should be one among 'PSP', 'dbPTM', 'all'.}
}
\value{
Returns a dataframe where each row corresponds to a modifiable residue.
}
\description{
Scans the indicated protein in search of glycosylation sites.
}
\details{
If db = 'all' has been selected, it may happen that the same residue appears in several rows if it is present in different databases.
}
\examples{
gl.scan('P08670', db = 'PSP')
}
\references{
Hornbeck et al. Nucleic Acids Res. 2019 47:D433-D441, (PMID: 30445427).

Huang et al. Nucleic Acids Res. 2019 47:D298-D308, (PMID: 30418626).
}
\seealso{
meto.scan(), ac.scan(), me.scan(), ub.scan(), su.scan(), p.scan(), sni.scan(), ni.scan(), ptm.scan(), reg.scan(), dis.scan()
}
\author{
Juan Carlos Aledo
}
