% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolutionary.R
\name{get.hssp}
\alias{get.hssp}
\title{Get a HSSP File}
\usage{
get.hssp(pdb, path, keepfiles = TRUE)
}
\arguments{
\item{pdb}{the 4-letter identifier of the PDB file.}

\item{path}{character string providing the path to the in-house HSSP database.}

\item{keepfiles}{logical, if TRUE the dataframes will be saved in the working directory and we will keep the hssp file.}
}
\value{
Returns a dataframe corresponding to the profile.Rda described above.
}
\description{
Gets a HSSP file of the requested structure.
}
\details{
In order to use this function, you need to obtain a local copy of the HSSB database. This function will obtain and parse the requested HSSP file. When the argument ‘keepfiles’ is set to TRUE, the get.hssp() function will build and save (in the working directory) the following 4 dataframes:
\itemize{
\item{id_seq_list.Rda:}  {This block of information holds the metadata per sequence, and some alignment statistic. See https://swift.cmbi.umcn.nl/gv/hssp for a detailed description of the information that can be find in this block.}
\item{id_aln.Rda}  {This dataframe contains the alignment itself (each sequence is a column). Additional information such as secondary structure, SASA, etc., is also found in this block.}
\item{id_profile.Rda}  {This dataframe holds per amino acid type its percentage in the list of residues observed at that position. In addition, this dataframe also informs about the entropy at each position, as well as the number of sequences spanning this position (NOOC).}
\item{id_insertions.Rda} {A dataframe with information regarding those sequences that contain insertions. See https://swift.cmbi.umcn.nl/gv/hssp for further details.}
}
}
\examples{
\dontrun{get.hssp(file = './1u8f.hssp')}
}
\references{
Touw et al (2015) Nucl. Ac. Res. 43:D364-368.
}
\seealso{
msa(), custom.aln(), list.hom(), parse.hssp(), shannon()
}
\author{
Juan Carlos Aledo
}
