% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{simulate_data_regression}
\alias{simulate_data_regression}
\title{Simulates data for single or multiple regression.}
\usage{
simulate_data_regression(coefs = 0.5, sample = 100, error = 0)
}
\arguments{
\item{coefs}{Desired theorethical coefs. Can be a single value or a list.}

\item{sample}{Desired sample size.}

\item{error}{The error (standard deviation of gaussian noise).}
}
\description{
Simulates data for single or multiple regression.
}
\details{
See https://stats.stackexchange.com/questions/59062/multiple-linear-regression-simulation
}
\examples{
library(psycho)

data <- simulate_data_regression(coefs = c(0.1, 0.8), sample = 50, error = 0)
fit <- lm(y ~ ., data = data)
coef(fit)
analyze(fit)
}
\author{
TPArrow
}
