% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{aovRoundDigits}
\alias{aovRoundDigits}
\title{aovRoundDigits}
\usage{
aovRoundDigits(aovObj)
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA}
}
\value{
dataframe
}
\description{
Round digits to n decimal places in ezANOVA table
}
\examples{
# Example 1:
# create dataframe with 2(Comp: comp vs. incomp) and 2(Side: left vs. right) factors/levels
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat,
                 RT = list("Comp:Side_comp:left"    = c(500, 150, 150),
                           "Comp:Side_comp:right"   = c(500, 150, 150),
                           "Comp:Side_incomp:left"  = c(500, 150, 150),
                           "Comp:Side_incomp:right" = c(500, 150, 150)))

aovRT <- aov(RT ~ Comp*Side + Error(VP/(Comp*Side)), dat)
aovRT <- aovRoundDigits(aovRT)
aovDispTable(aovRT)

# or using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovRoundDigits(aovRT)
aovDispTable(aovRT)

}
