% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aovTable.R
\name{aovTable}
\alias{aovTable}
\title{aovTable}
\usage{
aovTable(ezObj, effectSize = "pes", sphericityCorrections = TRUE,
  sphericityCorrectionType = "GG", marginalMeans = TRUE,
  removeSumSquares = TRUE, removeIntercept = TRUE,
  roundDigits = TRUE, numDigits = 2, dispAovTable = TRUE,
  dispAovMeans = FALSE, caption = NULL)
}
\arguments{
\item{ezObj}{Output from ezANOVA (NB. ezANOVA must be called with detailed = TRUE)}

\item{effectSize}{"ges" (generalized eta-squared), "es" (eta-squared), or
"pes" (partial eta-squared)}

\item{sphericityCorrections}{TRUE/FALSE}

\item{sphericityCorrectionType}{"GG" (default) vs. "HF"}

\item{marginalMeans}{Return marginal means via model.tables (NB. ezANOVA must
be called with return_aov = TRUE)}

\item{removeSumSquares}{TRUE/FALSE Remove SSn/SSd columns from the ANOVA table}

\item{removeIntercept}{TRUE/FALSE Remove intercept row from the ANOVA table}

\item{roundDigits}{TRUE/FALSE Round numerical values to numDigits}

\item{numDigits}{The number of digits to round to if roundDigits = TRUE}

\item{dispAovTable}{Display the ANOVA table in the command window}

\item{dispAovMeans}{Display the marginal means in the command window}

\item{caption}{Table caption}
}
\value{
list
}
\description{
Adjust ezANOVA table output. Options include calculation of alternative
effect sizes (eta squared, partial eta squared), the calculation of marginal
means and formating options for the ANOVA table (e.g., detailed, rounding).
}
\examples{
library(psychReport)
requiredPackages(c("dplyr", "ez"))
# Example 1:
# create dataframe with 2(Comp: comp vs. incomp) and 2(Side: left vs. right) factors/levels
dat <- createDF(nVP = 20,
                nTrl = 50,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat,
                 RT = list(list(c("Comp:comp", "Side:left"), vals = c(500, 150, 150)),
                           list(c("Comp:comp", "Side:right"), vals = c(500, 150, 150)),
                           list(c("Comp:incomp", "Side:left"), vals = c(500, 150, 150)),
                           list(c("Comp:incomp", "Side:right"), vals = c(500, 150, 150))))

# aggregate dat across trials
datAggVP <- dat \%>\%
    group_by(VP, Comp, Side) \%>\%
    summarize(N  = n(),
              rt = mean(RT))

# repeated measures ANOVA using ezANOVA
aovRT <- ezANOVA(datAggVP, dv=.(rt), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

}
