#' @title createDF
#'
#' @description Create dataframe in which to subsequently add simulated data.
#'
#' @param nVP Number of participants
#' @param nTrl Number of trials per factor/level for each participant
#' @param design Factors and levels
#'
#' @return dataframe
#'
#' @examples
#' library(psychReport)
#' # Example 1:
#' dat <- createDF()
#'
#' # Example 2:
#' dat <- createDF(nVP = 50, nTrl = 50,
#'                 design = list("Comp" = c("comp", "incomp")))
#'
#' # Example 3:
#' dat <- createDF(nVP = 50, nTrl = 50,
#'                 design = list("Comp" = c("comp", "incomp"),
#'                               "Side" = c("left", "right")))
#'
#' @export
createDF <- function(nVP = 20,
                     nTrl = 50,
                     design = list("A" = c("A1", "A2"), "B" = c("B1", "B2"))) {

  return(data.frame(VP = factor(rep(1:nVP, each = prod(sapply(design, length)) * nTrl)),
                    do.call("rbind", rep(list(expand.grid(design)), nVP*nTrl))))

}
