% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_way_interaction_plot.R
\name{two_way_interaction_plot}
\alias{two_way_interaction_plot}
\title{Two-way Interaction Plot}
\usage{
two_way_interaction_plot(
  model,
  data = NULL,
  graph_label_name = NULL,
  cateogrical_var = NULL,
  y_lim = NULL,
  plot_color = FALSE
)
}
\arguments{
\item{model}{object from \code{lm}, \code{nlme}, \code{lme4}, or \code{lmerTest}}

\item{data}{data frame. If the function is unable to extract data frame from the object, then you may need to pass it directly}

\item{graph_label_name}{vector of length 3 or function. Vector should be passed in the form of \code{c(response_var, predict_var1, predict_var2)}. Function should be passed as a switch function that return the label based on the name passed (e.g., a switch function)}

\item{cateogrical_var}{list. Specify the upper bound and lower bound directly instead of using ± 1 SD from the mean. Passed in the form of \code{list(var_name1 = c(upper_bound1, lower_bound1),var_name2 = c(upper_bound2, lower_bound2))}}

\item{y_lim}{the plot's upper and lower limit for the y-axis. Length of 2. Example: \code{c(lower_limit, upper_limit)}}

\item{plot_color}{default if \code{FALSE}. Set to \code{TRUE} if you want to plot in color}
}
\value{
an object of class \code{ggplot}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
The function creates a two-way interaction plot. It will creates a plot with ± 1 SD from the mean of the independent variable. See supported model below.
I recommend using concurrently with \code{lm_model} or \code{lme_model}.
}
\details{
It appears that ``predict` cannot handle categorical factors. All variables are converted to numeric before plotting.
}
\examples{
lm_fit <- lm(Sepal.Length ~ Sepal.Width * Petal.Width,
  data = iris
)
two_way_interaction_plot(lm_fit, data = iris)

}
