% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps.R
\name{rwe_cut}
\alias{rwe_cut}
\title{Create strata}
\usage{
rwe_cut(x, y = x, breaks = 5, keep_inx = NULL)
}
\arguments{
\item{x}{Vector of values based on which cut points will be determined}

\item{y}{Vector of values to be cut, default to be the same as \code{x}}

\item{breaks}{Number of cut points}

\item{keep_inx}{Indices of y that will be categorized as 1 or the largest bin
even if their values are out of range of x, i.e. the y's that will not be
trimmed}
}
\value{
A vector of stratum assignment for \code{y}. The y's that are outside
    the range of \code{x} and not in \code{keep_inx} are assigned \code{NA}
    in the result.
}
\description{
The cut points are chosen such that there will with equal numbers in each bin
for \code{x}. By default, values of \code{y} that are outside the range of
\code{x} will be excluded from the bins, unless they are in the
\code{keep_inx}.
}
\details{
Cut a sequence of numbers into bins.
}
\examples{

x <- rnorm(100,  mean = 0, sd = 1)
y <- rnorm(1000, mean = 1, sd = 2)
rwe_cut(x, y, breaks = 5)

}
