% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_utils.R
\name{splineGrad}
\alias{splineGrad}
\alias{splineGrad.default}
\title{Numerical derivatives of a series based on its smooth-spline representation}
\usage{
splineGrad(dseq, dsig, ...)

\method{splineGrad}{default}(dseq, dsig, plot.derivs = FALSE, ...)
}
\arguments{
\item{dseq}{numeric; a vector of positions for \code{dsig}.}

\item{dsig}{numeric; a vector of values (which will have a spline fit to them).}

\item{...}{additional arguments passed to \code{\link{smooth.spline}}}

\item{plot.derivs}{logical; should the derivatives be plotted?}
}
\value{
A matrix with columns representing \eqn{x, f(x), f'(x), f''(x)}
}
\description{
This computes the numerical derivatives of a spline 
representation of the input series; differentiation of spline curves is 
numerically efficient.
}
\details{
With smoothing, the numerical instability for "noisy" data can be drastically
reduced, since spline curves are inherently (at least) twice differentiable.
}
\examples{
\dontrun{#REX
library(psd)

##
## Spline gradient
##

set.seed(1234)
x <- seq(0,5*pi,by=pi/64)
y <- cos(x) #**2

splineGrad(x, y, TRUE)

# unfortunately, the presence of
# noise will affect numerical derivatives
y <- y + rnorm(length(y), sd=.1)
splineGrad(x, y, TRUE)

# so change the smoothing used in smooth.spline
splineGrad(x, y, TRUE, spar=0.2)
splineGrad(x, y, TRUE, spar=0.6)
splineGrad(x, y, TRUE, spar=1.0)

}#REX
}
\seealso{
\code{\link{smooth.spline}}, \code{\link{constrain_tapers}}
}
\author{
A.J. Barbour
}
