% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/psd-package.R
\docType{package}
\name{psd-package}
\alias{psd}
\alias{psd-package}
\alias{spec.psd}
\title{Adaptive power spectral density estimation using optimal sine multitapers}
\description{
Estimate the power spectral density (PSD)
of a timeseries using the sine multitapers, adaptively; the number of tapers
(and hence the resolution and uncertainty) vary according to
spectral shape. The main function to be used is \code{\link{pspectrum}}.
}
\details{
In frequency ranges where the spectrum  (\eqn{S})
is relatively flat, more tapers are taken and so a higher accuracy is
attained at the expense of lower frequency resolution.
The program makes a pilot estimate of the spectrum, then uses
Riedel and Sidorenko's (1995) estimate of the MSE (minimum square error),
which is based on an estimate of the second derivative of the PSD (\eqn{S''}).
The process is repeated \code{niter} times; further iteration may be necessary
to reach convergence, or an acceptably low spectral variance.
In this context the term "acceptable" is rather subjective: one can
usually detect an unconverged state by a rather jagged appearence of the spectrum,
but this is uncommon in our experience.

\subsection{Adaptive estimation}{
The adaptive process used is as follows. A quadratic fit to the logarithm of the
PSD within an adaptively determined frequency band is used to find an estimate of the local second
derivative of the spectrum. This is used in an equation like R-S equation (13) for
the MSE taper number, with the difference that a parabolic weighting is applied with
increasing taper order. Because the FFTs of the tapered series can be found by
resampling the FFT of the original time series (doubled in length and padded with zeros)
only one FFT is required per series, no matter how many tapers are used.
The spectra associated with the sine tapers are weighted before averaging with a
parabolically varying weight. The expression for the optimal number of tapers
given by R-S must be modified since it gives an unbounded result near points
where \eqn{S''} vanishes, which happens at many points in most spectra.
This program restricts the rate of growth of the number of tapers so that a
neighboring covering interval estimate is never completely contained in the next
such interval.
}

\subsection{Resolution and uncertainty}{
The sine multitaper adaptive process
introduces a variable resolution and error in the frequency domain.
See documentation for \code{\link{spectral_properties}} details on
how these are computed.
}
}
\author{
Andrew J. Barbour <andy.barbour@gmail.com> and Robert L. Parker
}
\references{
Barbour, A. J. and R. L. Parker, (2014),
psd: Adaptive, sine multitaper power spectral density estimation for R,
\emph{Computers and Geosciences}, \strong{63}, 1--8,
\url{http://dx.doi.org/10.1016/j.cageo.2013.09.015}

Percival, D. B., and A.T. Walden (1993),
Spectral analysis for physical applications,
\emph{Cambridge University Press}

Prieto, G. A., R. L. Parker, D. J. Thomson, F. L. Vernon, and R. L. Graham  (2007),
Reducing the bias of multitaper spectrum estimates,
\emph{Geophysical Journal International}, \strong{171}, 1269--1281,
\url{http://gji.oxfordjournals.org/content/171/3/1269}

Riedel, K. S., & Sidorenko, A. (1995),
Minimum bias multiple taper spectral estimation,
\emph{Signal Processing, IEEE Transactions on}, \strong{43}(1), 188--195.
}
\seealso{
\code{\link{psdcore}} and \code{\link{riedsid}}
}

