## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup,include=F----------------------------------------------------------
library(psc)
library(survival)

## -----------------------------------------------------------------------------
data <- psc::data

## -----------------------------------------------------------------------------
surv.mod <- psc::surv.mod
surv.mod

## -----------------------------------------------------------------------------
sfit <- survfit(Surv(data$time,data$cen)~1)
plot(sfit)

## ----include=F----------------------------------------------------------------
surv.psc <- pscfit(surv.mod,data)

## -----------------------------------------------------------------------------
attributes(surv.psc)

## -----------------------------------------------------------------------------
surv.post <- surv.psc$posterior
head(surv.post)

## -----------------------------------------------------------------------------
acf(surv.post$beta)

## -----------------------------------------------------------------------------
plot(surv.post$beta,typ="s")

## -----------------------------------------------------------------------------
summary(surv.post$beta)

## -----------------------------------------------------------------------------
print(surv.psc)
coef(surv.psc)
summary(surv.psc)

## -----------------------------------------------------------------------------
plot(surv.psc)

## -----------------------------------------------------------------------------
bin.mod <- psc::bin.mod
bin.mod

## ----include=F----------------------------------------------------------------
psc.bin <- pscfit(bin.mod,data)
psc.bin

## -----------------------------------------------------------------------------
summary(psc.bin)

## -----------------------------------------------------------------------------
plot(psc.bin)

## -----------------------------------------------------------------------------
count.mod <- psc::count.mod
count.mod
#data("count.mod")

## ----include=F----------------------------------------------------------------
psc.count <- pscfit(count.mod,data)
psc.count

## -----------------------------------------------------------------------------
summary(psc.count)

## -----------------------------------------------------------------------------
plot(psc.count)

## -----------------------------------------------------------------------------
cont.mod <- psc::cont.mod
cont.mod
#data("cont.mod")

## ----include=F----------------------------------------------------------------
psc.con <- pscfit(cont.mod,data)
psc.con

## -----------------------------------------------------------------------------
summary(psc.con)

## -----------------------------------------------------------------------------
plot(psc.con)

## ----include=F,echo=T---------------------------------------------------------

id1 <- which(data$ecog==0)
sub1 <- pscfit(surv.mod,data,id=id1)

id2 <- which(data$ecog==1)
sub2 <- pscfit(surv.mod,data,id=id2)

## -----------------------------------------------------------------------------
summary(sub1)
summary(sub2)

