% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{cut_off_funs}
\alias{cut_off_funs}
\alias{cut_off_none}
\alias{cut_off_after_first}
\alias{cut_off_after_last}
\alias{cut_off_after_events}
\title{Cut Off Functions}
\usage{
cut_off_none()

cut_off_after_first(time)

cut_off_after_last(time)

cut_off_after_events(n)
}
\arguments{
\item{time}{Time to cut off}

\item{n}{Number of events}
}
\value{
A \code{DataSimCutOff} object containing a cut-off function
}
\description{
Cut Off Functions
}
\section{Functions}{
\itemize{
\item \code{cut_off_none()}: No cut off is specified

\item \code{cut_off_after_first()}: Cut off at \code{time} after first enrolled patient

\item \code{cut_off_after_last()}: Cut off at \code{time} after last enrolled patient

\item \code{cut_off_after_events()}: Cut off after the time of the n-th event

}}
\examples{
cut_off_none()
cut_off_after_first(time = 36)
cut_off_after_last(time = 36)
cut_off_after_events(n = 20)
}
