% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_time.R
\name{set_clin}
\alias{set_clin}
\title{Specify parameters for enrollment time, drop-out pattern and analysis start time}
\usage{
set_clin(gamma, e_itv, CCOD, CCOD_t, etaC, etaE, d_itv)
}
\arguments{
\item{gamma}{A vector of rate of enrollment per unit of time}

\item{e_itv}{A vector of duration of time periods for recruitment with rates specified in \code{gamma}. Note that the length of \code{e_itv} should be same length as \code{gamma} or 1 less.}

\item{CCOD}{Type of analysis start time. Analysis starts at \code{CCOD_t} months after the first or last patient's enrollment if \code{CCOD = "fixed-first"} or \code{CCOD = "fixed-last"} respectively. Analysis starts when \code{CCOD_t} events have been observed if \code{CCOD = "event"}}

\item{CCOD_t}{Time difference between analysis start and first patient's enrollment if \code{CCOD = "fixed-first"}. Time difference between analysis start and last patient's enrollment if \code{CCOD = "fixed-last"}. Number of events observed when analysis starts if \code{CCOD = "event"}. Patients enrolled after the analysis start time are excluded from the analysis}

\item{etaC}{A vector for dropout rate per unit time for control arm}

\item{etaE}{A vector for dropout rate per unit time for experimental arm. If left \code{NULL}, it uses the same dropout rate as eta.}

\item{d_itv}{A vector of duration of time periods for dropping out the study with rates specified in \code{etaC} and \code{etaE}. Note that the length of \code{d_itv} should be same length as \code{etaC} or 1 less.}
}
\value{
A \code{.clinClass} class containing information on enrollment time, drop-out pattern and analysis start time
}
\description{
This function allows user to specify the enrollment and drop-out rate, and the type of clinical cut-off Date. Both enrollment times and drop-out times follow piece-wise exponential distribution.
}
\examples{
# set the operational parameter values for the trial
# analysis starts at64 time units after first patient in
set_clin(gamma = 10, e_itv = 4, etaC = 0.003,  CCOD = "fixed-first", CCOD_t = 64)

# analysis starts at 12 time units after last patient in
set_clin(gamma = 2, e_itv = 18, etaC = 0.005,  CCOD = "fixed-last", CCOD_t = 12)


}
\keyword{constructor}
