% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{ALR}
\alias{ALR}
\alias{ALR.default}
\alias{ALR.compositional}
\title{Additive logratio transformation}
\usage{
ALR(x, ...)

\method{ALR}{default}(x, inverse = FALSE, ...)

\method{ALR}{compositional}(x, ...)
}
\arguments{
\item{x}{an object of class \code{compositional} OR a matrix of
numerical values}

\item{...}{optional arguments}

\item{inverse}{perform the inverse inverse logratio transformation?}
}
\value{
a matrix of ALR coordinates OR an object of class
    \code{compositional} (if \code{inverse=TRUE}).
}
\description{
Calculates Aitchison's additive logratio transformation for a
dataset of class \code{compositional} or a compositional data
matrix.
}
\examples{
# logratio plot of trace element concentrations:
data(Namib)
alr <- ALR(Namib$Trace)
pairs(alr[,1:5])
title('log(X/Pb)')
}
