% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debugExceptions.R
\name{debug.error}
\alias{debug.error}
\alias{debug.warning}
\title{Tracking the Lineage of Errors and Warnings}
\usage{
debug.error(stack.overflow = FALSE)

debug.warning(..., all = FALSE)
}
\arguments{
\item{stack.overflow}{If TRUE, the error message will be searched for on Stack Overflow.}

\item{...}{The warning(s) to be queried.}

\item{all}{If TRUE, the lineages of all warnings are returned.}
}
\value{
debug.error returns a data frame representing the backwards lineage 
of the error in the execution, if any.

debug.warning returns a list of data frames of lineages for the queried 
        warnings.
}
\description{
debug.error displays the backwards lineage of (the 
statements leading up to) an error that occurred when R code was executed.

debug.warning displays the backwards lineage of (the 
statements leading up to) one or more warnings that occurred when R code was executed.
}
\details{
These functions are part of the provDebugR package.  To use them, you must
first initialise the debugger using
one its initialisation functions: \code{\link{prov.debug}}, 
\code{\link{prov.debug.file}}, or \code{\link{prov.debug.run}}.

The lineage is represented with a data frame that shows the R statements
whose execution led to the error or warning.  More specifically, 
each row of the data frame corresponds to one line of code.
The columns of the data frame are:
\itemize{
	\item scriptNum: The script number the statement is from.
 	\item scriptName: The name of the script the statement is from.
	\item startLine: The line number for the statement  If the statement spans multiple
	  lines, this will be the first line.
	\item code: The statement itself.  If the statement is long, this
	  will just be the start of the statement.
}
}
\examples{
\dontrun{
prov.debug.run("test.R")

debug.error()
debug.error(stack.overflow = TRUE)

debug.warning(1)
debug.warning(2,3)
debug.warning(all = TRUE)
}

}
\seealso{
provDebugR Initialisation Functions:

\code{\link{prov.debug}}

\code{\link{prov.debug.file}}

\code{\link{prov.debug.run}}

Other provDebugR Functions (non-initialisation):

\code{\link{debug.line}}: Returns all immediate inputs and outputs
             for the line(s) queried.

\code{\link{debug.lineage}}: Returns the forwards or backwards lineage
             of the data object(s) queried. The forwards lineage shows how the
             data object was used, and the backwards lineage shows how it was produced.

\code{\link{debug.state}}: Returns the state at the line(s) queried,
             after the line had been executed. The state is the list of all 
             variables and their values in the environment at the queried line.

\code{\link{debug.type.changes}}: Returns a data frame for each variable in
             the execution containing the instances where the data type changed.

\code{\link{debug.variable}}: Returns a data frame showing all instances
             of the variable(s) queried.

\code{\link{debug.view}}: Opens and displays the contents of each file or variable
             or variable queried.
}
