% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_treatment_enrichment.R
\name{calculate_treatment_enrichment}
\alias{calculate_treatment_enrichment}
\title{Check treatment enrichment}
\usage{
calculate_treatment_enrichment(
  data,
  protein_id,
  is_significant,
  binds_treatment,
  group = NULL,
  treatment_name,
  plot = TRUE,
  fill_colours = protti::protti_colours,
  fill_by_group = FALSE,
  facet_n_col = 2
)
}
\arguments{
\item{data}{a data frame contains at least the input variables.}

\item{protein_id}{a character column in the \code{data} data frame that contains the protein
accession numbers.}

\item{is_significant}{a logical column in the \code{data} data frame that indicates if the
corresponding protein has a significantly changing peptide. The input data frame may contain
peptide level information with significance information. The function is able to extract protein
level information from this.}

\item{binds_treatment}{a logical column in the \code{data} data frame that indicates if the
corresponding protein binds to the treatment. This information can be obtained from different
databases, e.g. UniProt.}

\item{group}{optional, character column in the \code{data} data frame that contains information by
which the analysis should be grouped. The analysis will be performed separately for each of the
groups. This is most likely a column that labels separate comparisons of different conditions.
In protti the \code{assign_missingness()} function creates such a column automatically.}

\item{treatment_name}{a character value that indicates the treatment name. It will be included
in the plot title.}

\item{plot}{a logical value indicating whether the result should be plotted or returned as a
table.}

\item{fill_colours}{a character vector that specifies the fill colours of the plot.}

\item{fill_by_group}{a logical value that specifies if the bars in the plot should be filled by group
if the group argument is provided. Default is \code{FALSE}.}

\item{facet_n_col}{a numeric value that specifies the number of columns the facet plot should have if
a \code{group} column was provided.}
}
\value{
A bar plot displaying the percentage of all detected proteins and all significant proteins
that bind to the treatment. A Fisher's exact test is performed to calculate the significance of
the enrichment in significant proteins compared to all proteins. The result is reported as a
p-value. If \code{plot = FALSE} a contingency table in long format is returned.
}
\description{
Check for an enrichment of proteins interacting with the treatment in significantly changing
proteins as compared to all proteins.
}
\examples{
# Create example data
data <- data.frame(
  protein_id = c(paste0("protein", 1:50)),
  significant = c(
    rep(TRUE, 20),
    rep(FALSE, 30)
  ),
  binds_treatment = c(
    rep(TRUE, 10),
    rep(FALSE, 10),
    rep(TRUE, 5),
    rep(FALSE, 25)
  ),
  group = c(
    rep("A", 5),
    rep("B", 15),
    rep("A", 15),
    rep("B", 15)
  )
)

# Plot treatment enrichment
calculate_treatment_enrichment(
  data,
  protein_id = protein_id,
  is_significant = significant,
  binds_treatment = binds_treatment,
  treatment_name = "Rapamycin",
  plot = TRUE
)

# Plot treatment enrichment by group
calculate_treatment_enrichment(
  data,
  protein_id = protein_id,
  group = group,
  is_significant = significant,
  binds_treatment = binds_treatment,
  treatment_name = "Rapamycin",
  plot = TRUE,
  fill_by_group = TRUE
)

# Calculate treatment enrichment
enrichment <- calculate_treatment_enrichment(
  data,
  protein_id = protein_id,
  is_significant = significant,
  binds_treatment = binds_treatment,
  plot = FALSE
)

enrichment
}
