% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize_pb.R
\name{serialize_pb}
\alias{protolite}
\alias{serialize_pb}
\alias{unserialize_pb}
\title{Serialize to Protocol Buffers}
\usage{
serialize_pb(object, connection = NULL, skip_native = FALSE)

unserialize_pb(msg)
}
\arguments{
\item{object}{an R object to serialize}

\item{connection}{a connection, file, or \code{NULL} for a raw vector}

\item{skip_native}{do not serialize 'native' (non-data) R objects. Setting to \code{TRUE}
will only serialize \emph{data} types (numeric, boolean, string, raw, list). The default
behavior is to fall back on base R \code{\link{serialize}} for non-data objects.}

\item{msg}{raw vector with the serialized \code{rexp.proto} message}
}
\description{
Serializes R objects to a general purpose protobuf message. It uses the same
\href{https://github.com/jeroenooms/protolite/blob/master/src/rexp.proto}{rexp.proto}
descriptor and mapping between R objects and protobuf messages as RHIPE and the
\link[RProtoBuf:serialize_pb]{RProtoBuf} package.
}
\details{
The \code{serialize_pb} and \code{unserialize_pb} reimplement the identically
named functions from the \code{RProtoBuf} package in pure \code{C++}. This makes
the function faster and simpler, but the output should be identical.
}
\examples{
# Serialize and unserialize an object
buf <- serialize_pb(iris)
out <- unserialize_pb(buf)
stopifnot(identical(iris, out))

\dontrun{ #Fully compatible with RProtoBuf
buf <- RProtoBuf::serialize_pb(iris, NULL)
out <- protolite::unserialize_pb(buf)
stopifnot(identical(iris, out))

# Other way around
buf <- protolite::serialize_pb(mtcars, NULL)
out <- RProtoBuf::unserialize_pb(buf)
stopifnot(identical(mtcars, out))
}
}

