% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/303.Sum_Leng_BASE_All_Graph.R
\name{PlotlengthEX}
\alias{PlotlengthEX}
\title{Plots the length summary for exact method}
\usage{
PlotlengthEX(n, alp, e, a, b)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{e}{- Exact method indicator  in [0, 1] {1: Clopper Pearson, 0.5: Mid P}
The input can also be a range of values between 0 and 1.}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}
}
\description{
Plots the length summary for exact method
}
\details{
Plot of Confidence interval for \code{p} based on inverting equal-tailed
binomial tests with null hypothesis \eqn{H0: p = p0} using expected length of the \eqn{n + 1} intervals.
}
\examples{
\dontrun{
n=5; alp=0.05;e=0.5;a=1;b=1 # Mid-p
PlotlengthEX(n,alp,e,a,b)
n=5; alp=0.05;e=1;a=1;b=1 #Clopper-Pearson
PlotlengthEX(n,alp,e,a,b)
n=5; alp=0.05;e=c(0.1,0.5,0.95,1);a=1;b=1 #Range including Mid-p and Clopper-Pearson
PlotlengthEX(n,alp,e,a,b)
}
}
\seealso{
Other Expected length  of base methods: \code{\link{PlotexplAS}},
  \code{\link{PlotexplAll}}, \code{\link{PlotexplBA}},
  \code{\link{PlotexplEX}}, \code{\link{PlotexplLR}},
  \code{\link{PlotexplLT}}, \code{\link{PlotexplSC}},
  \code{\link{PlotexplTW}}, \code{\link{PlotexplWD}},
  \code{\link{PlotlengthAS}}, \code{\link{PlotlengthAll}},
  \code{\link{PlotlengthBA}}, \code{\link{PlotlengthLR}},
  \code{\link{PlotlengthLT}}, \code{\link{PlotlengthSC}},
  \code{\link{PlotlengthTW}}, \code{\link{PlotlengthWD}},
  \code{\link{lengthAS}}, \code{\link{lengthAll}},
  \code{\link{lengthBA}}, \code{\link{lengthEX}},
  \code{\link{lengthLR}}, \code{\link{lengthLT}},
  \code{\link{lengthSC}}, \code{\link{lengthTW}},
  \code{\link{lengthWD}}
}

