% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileplot.R
\name{profileplot}
\alias{profileplot}
\title{Score Profile Plot}
\usage{
profileplot(form, person.id, standardize = TRUE, interval = 10,
  by.pattern = TRUE, original.names = TRUE)
}
\arguments{
\item{form}{A matrix or dataframe including two or more subscores.}

\item{person.id}{A vector that includes person ID values (Optional).}

\item{standardize}{If not FALSE, all scores are rescaled with a mean of 0 and standard deviation of 1. Default is TRUE.}

\item{interval}{The number of equal intervals from the mimimum score to the meximum score. Default is 10. Ignored when by.pattern=FALSE.}

\item{by.pattern}{If TRUE, the function creates a profile plot with level and pattern values using ggplot2. Otherwise, the function creates a profile plot showing profile scores of persons using the base graphics in R. Default is TRUE.}

\item{original.names}{Use the original column names in the data. Otherwise, columns are renamed as v1,v2,.... Default is TRUE.}
}
\value{
The \code{profileplot} functions returns a score profile plot from either \link[ggplot2]{ggplot} or the base graphics in R.
}
\description{
The \code{profileplot} function creates a profile plot for a matrix or dataframe with multiple scores or subscores using \code{\link[ggplot2]{ggplot}} function in \code{ggplot2} package.
}
\examples{
\dontrun{
data(PS)
 myplot <- profileplot(PS[,2:4], person.id = PS$Person,by.pattern = TRUE, original.names = TRUE)
 myplot

data(leisure)
leis.plot <- profileplot(leisure[,2:4],standardize=TRUE,by.pattern=FALSE)
leis.plot
}
}
\seealso{
\link[ggplot2]{ggplot}, \link{PS}
}

