% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processanimateR.R
\name{animate_process}
\alias{animate_process}
\title{Animate cases on a process map}
\usage{
animate_process(eventlog, processmap = process_map(eventlog, render = F),
  animation_mode = "absolute", animation_duration = 60, token_size = NULL,
  token_color = NULL, token_image = NULL, width = NULL, height = NULL)
}
\arguments{
\item{eventlog}{The event log object that should be animated}

\item{processmap}{The process map created with processmapR that the event log should be animated on,
if not provided a standard process map will be generated by using processmapR::process_map.}

\item{animation_mode}{Whether to animate the cases according to their actual time of occurence ("absolute") or to start all cases at once ("relative").}

\item{animation_duration}{The overall duration of the animation, all times are scaled according to this overall duration.}

\item{token_size}{The event attribute (character) or alternatively a data frame with three columns (case, time, size) matching the case identifier of the supplied event log.
The token size is scaled accordingly during the animation (default size is 4). You may use \code{\link{add_token_size}} to add a suitable attribute to the event log.}

\item{token_color}{The event attribute (character) or alternatively a data frame with three columns (case, time, color) matching the case identifier of the supplied event log.
The token color is change accordingly during the animation (default color is orange). You may use \code{\link{add_token_color}} to add a suitable attribute to the event log.}

\item{token_image}{The event attribute (character) or alternatively a data frame with three columns (case, time, image) matching the case identifier of the supplied event log.
The token image is change accordingly during the animation (by default a SVG shape is used).}

\item{width}{The width of the htmlwidget.}

\item{height}{The height of the htmlwidget.}
}
\description{
A function for creating a SVG animation of an event log on a process map created by processmapR.
}
\examples{
{
# Load example event log
library(eventdataR)

# Animate the process with default options (absolute time and 60s)
animate_process(patients)

# Change default token sizes
animate_process(patients, token_size = 2)

# Change default token color
animate_process(patients, token_color = "red")

\donttest{
# Change default token image (GIFs work too)
animate_process(patients, token_image = "https://upload.wikimedia.org/wikipedia/en/5/5f/Pacman.gif")

# Change token color based on a numeric attribute, here the nonsensical 'time' of an event
animate_process(add_token_color(patients, "time", "color"), token_color = "color")

# Change token color based on a factor attribute
animate_process(add_token_color(patients, "employee", "color",
                color_mapping = scales::col_factor("Set3", patients$employee)),
                token_color = "color")

# Next example requires the 'dplyr' and 'edeaR' packages
library(dplyr)
library(edeaR)

# Change token_color based on colors in a second data frame
# Extract only the lacticacid measurements
lactic <- sepsis \%>\%
    mutate(lacticacid = as.numeric(lacticacid)) \%>\%
    filter_activity(c("LacticAcid")) \%>\%
    as.data.frame() \%>\%
    select("case" = case_id, "time" =  timestamp, lacticacid)
# Create a numeric color scale
cscale <- scales::col_numeric("Oranges", lactic$lacticacid , na.color = "white")
# Create colors data frame for animate_process
lacticColors <- lactic \%>\%
    mutate(color = cscale(lacticacid))
sepsisBase <- sepsis \%>\%
    filter_activity(c("LacticAcid", "CRP", "Leucocytes", "Return ER",
                      "IV Liquid", "IV Antibiotics"), reverse = TRUE) \%>\%
    filter_trace_frequency(percentage = 0.95)
animate_process(sepsisBase, token_color = lacticColors, animation_mode = "relative",
                animation_duration = 600)
}
}

}
\seealso{
processmapR:process_map
}
\author{
Felix Mannhardt <felix.mannhardt@sintef.no> (SINTEF Technology and Society)
}
