% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statisticalDiagram.R
\name{statisticalDiagram}
\alias{statisticalDiagram}
\title{Draw statistical diagram}
\usage{
statisticalDiagram(
  no = 1,
  radx = 0.1,
  rady = 0.04,
  xmargin = 0.01,
  arrowlabel = TRUE,
  arrowslabels = NULL,
  arrowslty = NULL,
  labels = list(),
  nodeslabels = list(),
  whatLabel = "name",
  fit = NULL,
  estimateTable = NULL,
  digits = 3,
  covar = list(),
  addCovar = TRUE,
  type = NULL,
  includeLatentVars = FALSE,
  addprime = TRUE,
  box.col = "white",
  xlim = c(0, 1),
  ylim = NULL
)
}
\arguments{
\item{no}{process macro model number}

\item{radx}{horizontal radius of the box.}

\item{rady}{vertical radius of the box.}

\item{xmargin}{horizontal margin of plot}

\item{arrowlabel}{logical whether or not draw arrowlabel}

\item{arrowslabels}{A character vector}

\item{arrowslty}{linetype of arrows}

\item{labels}{A list of character string}

\item{nodeslabels}{A list of character string}

\item{whatLabel}{What should the edge labels indicate in the path diagram? Choices are c("est","std","name","label")}

\item{fit}{A list of class lm or an object of lacc lavaan}

\item{estimateTable}{A data.frame}

\item{digits}{Integer indicating the number of decimal places}

\item{covar}{Optional list of covariates}

\item{addCovar}{Logical. Whether or not include covariates}

\item{type}{An integer}

\item{includeLatentVars}{A logical}

\item{addprime}{logical. Whether or not add prime to label "c"}

\item{box.col}{fill  color of the box}

\item{xlim}{the x limits (min,max) of the plot}

\item{ylim}{the y limits (min,max) of the plot}
}
\description{
Draw statistical diagram
}
\examples{
statisticalDiagram(no=1)
covar=list(name=c("posemot","ideology","sex"),site=list(c("Y"),c("Y"),c("Y")))
statisticalDiagram(no=1,covar=covar)
covar=list(name=c("posemot","ideology","sex"),site=list(c("M","Y"),c("Mi","Y"),c("Mi","Y")))
covar=list(name=c("C1","C2"),site=list(c("M","Y"),"Y"))
statisticalDiagram(no=4,covar=covar)
statisticalDiagram(no=8,covar=covar)
labels=list(X="wintense",Mi="cogapp",Y="emotion")
nodeslabels=list(X="Work\nIntensity",Mi="Cognitive\nAppraisal",Y="Emotional\nExhaustion")
statisticalDiagram(4,labels=labels)
statisticalDiagram(4,labels=nodeslabels)
statisticalDiagram(4,labels=labels,nodeslabels=nodeslabels)
labels=list(X="GDP\nper inhabitant",M="Illiteracy Rate",Y="Mean Life\nExpectation")
statisticalDiagram(4,labels=labels)
statisticalDiagram(4,labels=labels,arrowslabels=c("e","f","g"),whatLabel="label")
}
