% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_names.R
\name{make_spanish_names}
\alias{make_spanish_names}
\title{Generates a random name from a list of common Spanish words.}
\usage{
make_spanish_names(
  n,
  n_words = 3,
  retry = FALSE,
  sep = "_",
  case = c("lower", "upper", "title")
)
}
\arguments{
\item{n}{The number of random names to be generated.}

\item{n_words}{The number of words to combine into a name.}

\item{retry}{If `TRUE`, a random integer between 1 and 10 is appended to each
generated name.}

\item{sep}{A character string to separate the terms. Not `NA_character_`.}

\item{case}{One of either "lower", "upper", or "title". The capitalization to
use for each word.}
}
\value{
A character vector of length `n` of random names, each composed of
`n_word` terms capitalized according to `case` separated by `sep`. Note that
names are not guaranteed to be unique.
}
\description{
This function generates `n` random names, each a combination of `n_words`
words selected from [spanish_words].
}
\examples{
make_spanish_names(1, n_words = 2)
make_spanish_names(2, retry = TRUE)
}
