% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prism_annual.R, R/get_prism_dailys.R,
%   R/get_prism_monthlys.R, R/get_prism_normals.R
\name{get_prism_annual}
\alias{get_prism_annual}
\alias{get_prism_dailys}
\alias{get_prism_monthlys}
\alias{get_prism_normals}
\title{Download prism data}
\usage{
get_prism_annual(
  type,
  years,
  keepZip = TRUE,
  keep_pre81_months = FALSE,
  service = NULL
)

get_prism_dailys(
  type,
  minDate = NULL,
  maxDate = NULL,
  dates = NULL,
  keepZip = TRUE,
  check = "httr",
  service = NULL
)

get_prism_monthlys(
  type,
  years,
  mon = 1:12,
  keepZip = TRUE,
  keep_pre81_months = TRUE,
  service = NULL
)

get_prism_normals(type, resolution, mon = NULL, annual = FALSE, keepZip = TRUE)
}
\arguments{
\item{type}{The type of data to download. Must be "ppt", "tmean", "tmin",
"tmax", "tdmean", "vpdmin", or "vpdmax". Note that \code{tmean ==  mean(tmin, tmax)}.}

\item{years}{a valid numeric year, or vector of years, to download data for.}

\item{keepZip}{if \code{TRUE}, leave the downloaded zip files in your
'prism.path', if \code{FALSE}, they will be deleted.}

\item{keep_pre81_months}{The pre-1981 data includes all monthly data and the
annual data for the specified year. If you need annual and monthly data it
is advantageous to keep all the monthly data when downloading the annual
data so you don't have to download the zip file again. When downloading
annual data, this defaults to \code{FALSE}. When downloading monthly data, this
defaults to \code{TRUE}.}

\item{service}{Either \code{NULL} (default) or a URL provided by PRISM staff
for subscription-based service. Example:
"http://services.nacse.org/prism/data/subscription/800m". To use the
subscription option, you must use an IP address registered with PRISM
staff. When \code{NULL}, URL defaults to:
"http://services.nacse.org/prism/data/public/4km".}

\item{minDate}{Date to start downloading daily data. Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{maxDate}{Date to end downloading daily data.  Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{dates}{A vector of dates to download daily data. Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{check}{One of "httr" or "internal". See details.}

\item{mon}{a valid numeric month, or vector of months. Required for
\code{get_prism_monthlys()}. Can be \code{NULL} for \code{get_prism_normals()}.}

\item{resolution}{The spatial resolution of the data, must be either "4km"
or "800m".}

\item{annual}{if \code{TRUE} download annual normals.}
}
\description{
Download grid cell data from the
\href{https://prism.nacse.org/}{prism project}. Temperature (min, max,
and mean), mean dewpoint temperature, precipitation, and vapor pressure
deficit (min and max) can be downloaded for annual (\code{get_prism_annual()}),
monthly (\code{get_prism_monthlys()}), daily (\code{get_prism_dailys()}), and 30-year
averages (\code{get_prism_normals()}). Data are at 4km resolution, except for the
normals which can also be downloaded at 800m resolution.

Download data from the prism project for 30 year normals at 4km
or 800m grid cell resolution for precipitation, mean, min and max
temperature
}
\details{
A valid download directory must exist before downloading any prism data. This
can be set using \code{\link[=prism_set_dl_dir]{prism_set_dl_dir()}} and can be verified using
\code{\link[=prism_check_dl_dir]{prism_check_dl_dir()}}.

For the \code{check} parameter, "httr", the default, checks the file name using
the web service, and downloads if that file name is not in the file system.
"internal" (much faster) only attempts to download layers that are not
already in the file system as stable. "internal" should be used with caution
as it is not robust to changes in version or file names.
}
\section{Annual and Monthly}{


Annual and monthly prism data are available from 1891 to present. For
1891-1980 data, monthly and annual data are grouped together in one download
file; \code{keep_pre81_months} determines if the other months/yearly data are kept
after the download.  Data will be downloaded for all specified months (\code{mon})
in all the \code{years} in the supplied vectors.
}

\section{Daily}{


Daily prism data are available beginning on January 1, 1981. To download the
daily data, dates must be in the proper format or downloading will not work
properly. Dates can be specified using either a date range via \code{minDate} and
\code{maxDate}, or a vector of \code{dates}, but not both.
}

\section{Normals}{


30-year normals are currently computed using 1991-2020 and are available at
4km and 800m resolution. See
\url{https://prism.nacse.org/normals/}.
If \code{mon} is specified and \code{annual} is \code{TRUE}, then monthly and annual normal
data will be downloaded.
}

\examples{
\dontrun{
# Get all annual average temperature data from 1990 to 2000
get_prism_annual(type = "tmean", year = 1990:2000, keepZip = FALSE)
}

\dontrun{
# get daily average temperature data for June 1 - 14, 2013
get_prism_dailys(
  type = "tmean", 
  minDate = "2013-06-01", 
  maxDate = "2013-06-14", 
  keepZip=FALSE
)

# get precipitation datat for June 1, 2013
get_prism_dailys(type = "ppt", dates = "2013/06/01", keepZip = FALSE)

# get average temperature for three specific days
get_prism_dailys(
  type="tmean", 
  dates = as.Date("2013-06-01", "2013-06-14", "2014-06-30"), 
  keepZip=FALSE
)

# will fail:
get_prism_dailys(
  type = "ppt", 
  minDate = "2013-06-01", 
  dates = "2013-06-14", 
  keepZip = FALSE
)

get_prism_dailys(
  type = "ppt", 
  minDate = "2013-06-01", 
  keepZip=FALSE
)
}

\dontrun{
# Get all the precipitation data for January from 1990 to 2000
get_prism_monthlys(type = "ppt", years = 1990:2000, mon = 1, keepZip = FALSE)

# Get January-December 2005 monthly precipitation
get_prism_monthlys(type = "ppt", years = 2005, mon = 1:12, keepZip = FALSE)
}

\dontrun{
# Get 30 year normal values for January rainfall
get_prism_normals(type = "ppt", resolution = "4km", mon = 1, keepZip = FALSE)

# Get monthly (every month) and annual 30-year normals for mean temperature
get_prism_normals(
  type = "tmean", 
  resolution = "800m", 
  mon = 1:12, 
  annual = TRUE,
  keepZip = FALSE
)
}

}
