% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pla.R
\name{pla.keep_blocks}
\alias{pla.keep_blocks}
\title{Keep Blocks}
\usage{
pla.keep_blocks(object, blocks, ...)
}
\arguments{
\item{object}{a \code{pla} object.}

\item{blocks}{a list of numeric values indicating the indices of the blocks
that should be kept.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
list of the following attributes:
\item{x}{
  a numeric matrix or data frame containing the reduced set of original
  variables.
}
\item{cc_matrix}{
  a numeric matrix or data frame which contains the conditional dispersion
  matrix. Depending on the pla procedure, this is either the conditional
  covariance matrix or the conditional correlation matrix.
}
}
\description{
Used to pass the indices of the blocks we want to keep 
(i.e. which we do no want to be discarded).
}
\examples{
if(requireNamespace("AER")){
require(AER)
data("OECDGrowth")

pla(OECDGrowth,cor=TRUE,thresholds = 0.5)

## we obtain three blocks: (randd), (gdp85,gdp60) and 
## (invest, school, popgrowth). Block 1, i.e. the 1x1 block 
## (randd), explains only 5.76\% of the overall variance.
## Hence, discarding this block seems appropriate. Therefore,
## we keep block 2 and block 3

pla_obj = pla(OECDGrowth,cor=TRUE,thresholds = 0.5)
pla.keep_blocks(pla_obj, c(2,3)) ## keep block 2 and block 3
}

}
