# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Test for Prime Numbers
#'
#' Test whether a vector of numbers is prime or composite.
#'
#' @param x an integer vector containing elements to be tested for primality.
#'
#' @examples
#' is_prime(4:7)
#' ## [1] FALSE  TRUE FALSE  TRUE
#'
#' is_prime(1299827)
#' ## [1] TRUE
#'
#' @return A logical vector.
#' @author Os Keyes and Paul Egeler, MS
#' @export
is_prime <- function(x) {
    .Call('_primes_is_prime', PACKAGE = 'primes', x)
}

#' @rdname k_tuple
#' @export
k_tuple <- function(min, max, tuple) {
    .Call('_primes_k_tuple', PACKAGE = 'primes', min, max, tuple)
}

#' Find the Next and Previous Prime Numbers
#'
#' Find the next prime numbers or previous prime numbers over a vector.
#'
#' For `prev_prime`, if a value is less than or equal to 2, the function will
#' return `NA`.
#'
#' @param x a vector of integers from which to start the search.
#'
#' @examples
#' next_prime(5)
#' ## [1] 7
#'
#' prev_prime(5:7)
#' ## [1] 3 5 5
#' @aliases prev_prime
#' @return An integer vector of prime numbers.
#' @author Paul Egeler, MS
#' @export
next_prime <- function(x) {
    .Call('_primes_next_prime', PACKAGE = 'primes', x)
}

#' @rdname next_prime
#' @export
prev_prime <- function(x) {
    .Call('_primes_prev_prime', PACKAGE = 'primes', x)
}

prime_count <- function(n, upper_bound) {
    .Call('_primes_prime_count', PACKAGE = 'primes', n, upper_bound)
}

#' Perform Prime Factorization on a Vector
#'
#' Compute the prime factors of elements of an integer vector.
#'
#' @param x an integer vector.
#'
#' @examples
#' prime_factors(c(1, 5:7, 99))
#' ## [[1]]
#' ## integer(0)
#' ##
#' ## [[2]]
#' ## [1] 5
#' ##
#' ## [[3]]
#' ## [1] 2 3
#' ##
#' ## [[4]]
#' ## [1] 7
#' ##
#' ## [[5]]
#' ## [1]  3  3 11
#'
#' @return A list of integer vectors reflecting the prime factorizations of
#'   each element of the input vector.
#' @author Paul Egeler, MS
#' @export
prime_factors <- function(x) {
    .Call('_primes_prime_factors', PACKAGE = 'primes', x)
}

#' @rdname primorial
#' @export
primorial_n <- function(n) {
    .Call('_primes_primorial_n', PACKAGE = 'primes', n)
}

#' @rdname primorial
#' @export
primorial_p <- function(n) {
    .Call('_primes_primorial_p', PACKAGE = 'primes', n)
}

generate_primes_ <- function(min, max) {
    .Call('_primes_generate_primes_', PACKAGE = 'primes', min, max)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_primes_RcppExport_registerCCallable', PACKAGE = 'primes')
})
