% Generated by roxygen2 (4.0.1): do not edit by hand
\name{primer_search}
\alias{primer_search}
\title{Query a pair of primers using ncbi's Primer-BLAST, if primers contain iupac}
\usage{
primer_search(forward, reverse, num_aligns = 500, num_permutations = 25,
  ..., .parallel = FALSE, .progress = "none")
}
\arguments{
\item{forward}{forward primer to search by 5'-3' on plus strand}

\item{reverse}{reverse primer to search by 5'-3' on minus strand}

\item{num_aligns}{number of alignment results to keep}

\item{num_permutations}{the number of primer permutations to search, if the degenerate bases
cause more than this number of permutations to exist, this number will be
sampled from all possible permutations.}

\item{...}{additional arguments passed to Primer-Blast}

\item{.parallel}{if 'TRUE', perform in parallel, using parallel backend
provided by foreach}

\item{.progress}{name of the progress bar to use, see 'create_progress_bar'}
}
\value{
data.frame of primer hits
}
\description{
ambiguity codes, enumerate all possible combinations and combine the
results.
}

