% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differences.R
\name{prec_or}
\alias{prec_or}
\title{Sample size or precision for an odds ratio}
\usage{
prec_or(
  p1,
  p2,
  n1 = NULL,
  r = 1,
  conf.width = NULL,
  conf.level = 0.95,
  method = c("gart", "woolf", "indip_smooth"),
  ...
)
}
\arguments{
\item{p1}{risk among exposed.}

\item{p2}{risk among unexposed.}

\item{n1}{number of patients in exposed group.}

\item{r}{allocation ratio (relative size of unexposed and exposed cohort
(\code{n2} / \code{n1})).}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}

\item{method}{Exactly one of \code{indip_smooth} (\emph{default}),
\code{gart}, or \code{woolf}. Methods can be abbreviated.}

\item{...}{other arguments to uniroot (e.g. \code{tol}).}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements.
}
\description{
\code{prec_or} returns the sample size or the precision for the
provided proportions.
}
\details{
Exactly one of the parameters \code{n1} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

Woolf (\code{woolf}), Gart (\code{gart}), and Independence-smoothed logit
(\code{indip_smooth}) belong to a general family of adjusted confidence
intervals, adding 0 (woolf) to each cell, 0.5 (gart) to each cell, or an
adjustment for each cell based on observed data (independence-smoothed). In
gart and indip_smooth, estimate of the CI is not possible if \eqn{p1 = 0}, in
which case the OR becomes 0, but the lower level of the CI is > 0. Further,
if \eqn{p1 = 1} and \eqn{p2 < 1}, or if \eqn{p1 > 0} and \eqn{p2 = 0}, the OR
becomes \eqn{\infty}, but the upper limit of the CI is finite. For the
approximate intervals, \code{gart} and \code{indip_smooth} are the
recommended intervals (Fagerland et al. 2011).

\code{\link[stats]{uniroot}} is used to solve n for the woolf, gart, and
indip_smooth method.
}
\references{
Fagerland MW, Lydersen S, Laake P (2015). \emph{Recommended
confidence intervals for two independent binomial proportions}. Statistical
Methods in Medical Research, 24(2):224-254.
\href{https://doi.org/10.1177/0962280211415469}{doi:10.1177/0962280211415469}.
}
